/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.doctrine2.annotations.odm.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.annotation.util.AnnotationUtils;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class ComplexAnnotationLineParser
implements AnnotationLineParser {
    private static final Set<ComplexAnnotation> ANNOTATIONS = new HashSet<ComplexAnnotation>();

    public AnnotationParsedLine parse(String line) {
        AnnotationParsedLine.ParsedLine result = null;
        String[] tokens = line.split("\\(");
        for (ComplexAnnotation annotation : ANNOTATIONS) {
            if (tokens.length <= 0 || !AnnotationUtils.isTypeAnnotation((String)tokens[0], (String)annotation.getName())) continue;
            String annotationName = tokens[0].trim();
            String description = line.substring(annotationName.length()).trim();
            HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
            types.put(new OffsetRange(0, annotationName.length()), annotationName);
            types.putAll(AnnotationUtils.extractInlineAnnotations((String)line, annotation.getInlineAnnotations()));
            types.putAll(AnnotationUtils.extractTypesFromParameters((String)line, annotation.getTypedParamRegexs()));
            result = new AnnotationParsedLine.ParsedLine(annotation.getName(), types, description, true);
            break;
        }
        return result;
    }

    static {
        HashSet<String> inlineAnnotations = new HashSet<String>();
        inlineAnnotations.add("Index");
        HashSet<String> typedParamRegexs = new HashSet<String>();
        typedParamRegexs.add("repositoryClass");
        ANNOTATIONS.add(new ComplexAnnotation("Document", inlineAnnotations, typedParamRegexs));
    }

    private static class ComplexAnnotation {
        private final String name;
        private final Set<String> inlineAnnotations;
        private final Set<String> typedParamRegexs;

        public ComplexAnnotation(String name, Set<String> inlineAnnotations, Set<String> typedParamRegexs) {
            this.name = name;
            this.inlineAnnotations = inlineAnnotations;
            this.typedParamRegexs = typedParamRegexs;
        }

        String getName() {
            return this.name;
        }

        Set<String> getInlineAnnotations() {
            return this.inlineAnnotations;
        }

        Set<String> getTypedParamRegexs() {
            return this.typedParamRegexs;
        }
    }
}

