/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNodeFactory;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDictionary;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import java.util.Set;

public abstract class CreateObjectNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    protected CreateObjectNode(JSContext context) {
        this.context = context;
    }

    public static CreateObjectNode create(JSContext context) {
        return new CreateOrdinaryObjectNode(context);
    }

    public static CreateObjectWithPrototypeNode createOrdinaryWithPrototype(JSContext context) {
        return CreateObjectNode.createWithPrototype(context, null, JSOrdinary.INSTANCE);
    }

    public static CreateObjectWithPrototypeNode createOrdinaryWithPrototype(JSContext context, JavaScriptNode prototypeExpression) {
        return CreateObjectNode.createWithPrototype(context, prototypeExpression, JSOrdinary.INSTANCE);
    }

    public static CreateObjectWithPrototypeNode createWithPrototype(JSContext context, JavaScriptNode prototypeExpression, JSClass jsclass) {
        return CreateObjectWithCachedPrototypeNode.create(context, prototypeExpression, jsclass);
    }

    static CreateObjectNode createDictionary(JSContext context) {
        return new CreateDictionaryObjectNode(context);
    }

    public abstract DynamicObject execute(VirtualFrame var1);

    protected abstract CreateObjectNode copyUninitialized(Set<Class<? extends Tag>> var1);

    final JSContext getContext() {
        return this.context;
    }

    private static class CreateDictionaryObjectNode
    extends CreateObjectNode {
        protected CreateDictionaryObjectNode(JSContext context) {
            super(context);
        }

        @Override
        public DynamicObject execute(VirtualFrame frame) {
            return JSDictionary.create(this.context);
        }

        @Override
        protected CreateObjectNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new CreateDictionaryObjectNode(this.context);
        }
    }

    protected static abstract class CreateObjectWithCachedPrototypeNode
    extends CreateObjectWithPrototypeNode {
        protected final JSClass jsclass;

        protected CreateObjectWithCachedPrototypeNode(JSContext context, JavaScriptNode prototypeExpression, JSClass jsclass) {
            super(context, prototypeExpression);
            this.jsclass = jsclass;
            assert (this.isOrdinaryObject() || this.isPromiseObject());
        }

        protected static CreateObjectWithPrototypeNode create(JSContext context, JavaScriptNode prototypeExpression, JSClass jsclass) {
            return CreateObjectNodeFactory.CreateObjectWithCachedPrototypeNodeGen.create(context, prototypeExpression, jsclass);
        }

        @Specialization(guards={"!context.isMultiContext()", "isValidPrototype(cachedPrototype)", "prototype == cachedPrototype"}, limit="1")
        final DynamicObject doCachedPrototype(DynamicObject prototype, @Cached(value="prototype") DynamicObject cachedPrototype, @Cached(value="getProtoChildShape(cachedPrototype)") Shape protoChildShape) {
            if (this.isPromiseObject()) {
                return JSPromise.create(this.context, protoChildShape);
            }
            if (this.isOrdinaryObject()) {
                return JSOrdinary.create(this.context, protoChildShape);
            }
            throw Errors.unsupported("unsupported object type");
        }

        @Specialization(guards={"isOrdinaryObject()", "isValidPrototype(prototype)"}, replaces={"doCachedPrototype"})
        final DynamicObject doOrdinaryInstancePrototype(DynamicObject prototype, @CachedLibrary(limit="3") @Cached.Shared(value="setProtoNode") DynamicObjectLibrary setProtoNode) {
            DynamicObject object = JSOrdinary.createWithoutPrototype(this.context);
            setProtoNode.put(object, (Object)JSObject.HIDDEN_PROTO, (Object)prototype);
            return object;
        }

        @Specialization(guards={"isPromiseObject()", "isValidPrototype(prototype)"}, replaces={"doCachedPrototype"})
        final DynamicObject doPromiseInstancePrototype(DynamicObject prototype, @CachedLibrary(limit="3") @Cached.Shared(value="setProtoNode") DynamicObjectLibrary setProtoNode) {
            DynamicObject object = JSPromise.createWithoutPrototype(this.context);
            setProtoNode.put(object, (Object)JSObject.HIDDEN_PROTO, (Object)prototype);
            return object;
        }

        @Specialization(guards={"isOrdinaryObject() || isPromiseObject()", "!isValidPrototype(prototype)"})
        final DynamicObject doNotJSObjectOrNull(Object prototype) {
            return JSOrdinary.create(this.context);
        }

        final Shape getProtoChildShape(DynamicObject prototype) {
            return prototype == Null.instance ? this.context.getEmptyShapeNullPrototype() : JSObjectUtil.getProtoChildShape(prototype, this.jsclass, this.context);
        }

        final boolean isOrdinaryObject() {
            return this.jsclass == JSOrdinary.INSTANCE;
        }

        final boolean isPromiseObject() {
            return this.jsclass == JSPromise.INSTANCE;
        }

        @Override
        protected CreateObjectWithPrototypeNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return CreateObjectWithCachedPrototypeNode.create(this.context, JavaScriptNode.cloneUninitialized(this.prototypeExpression, materializedTags), this.jsclass);
        }
    }

    public static abstract class CreateObjectWithPrototypeNode
    extends CreateObjectNode {
        @Node.Child
        @Executed
        protected JavaScriptNode prototypeExpression;

        protected CreateObjectWithPrototypeNode(JSContext context, JavaScriptNode prototypeExpression) {
            super(context);
            this.prototypeExpression = prototypeExpression;
        }

        public abstract DynamicObject execute(VirtualFrame var1, DynamicObject var2);

        public final DynamicObject execute(DynamicObject prototype) {
            assert (this.prototypeExpression == null);
            return this.execute(null, prototype);
        }

        @Override
        protected abstract CreateObjectWithPrototypeNode copyUninitialized(Set<Class<? extends Tag>> var1);
    }

    private static class CreateOrdinaryObjectNode
    extends CreateObjectNode {
        protected CreateOrdinaryObjectNode(JSContext context) {
            super(context);
        }

        @Override
        public DynamicObject execute(VirtualFrame frame) {
            return JSOrdinary.create(this.context);
        }

        @Override
        protected CreateObjectNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new CreateOrdinaryObjectNode(this.context);
        }
    }
}

