/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class SourceRef {
    public final Snapshot source;
    private Map<HCLElement, OffsetRange> elementOffsets = new HashMap<HCLElement, OffsetRange>();
    private TreeMap<OffsetRange, HCLElement> elementAt = new TreeMap((o1, o2) -> o1.getStart() != o2.getStart() ? o1.getStart() - o2.getStart() : o2.getEnd() - o1.getEnd());

    public SourceRef(Snapshot source) {
        this.source = source;
    }

    private void add(HCLElement e, OffsetRange r) {
        if (!this.elementOffsets.containsKey(e)) {
            this.elementOffsets.put(e, r);
            this.elementAt.put(r, e);
        }
    }

    void elementCreated(HCLElement.CreateContext ctx) {
        this.add(ctx.element, new OffsetRange(ctx.start.getStartIndex(), ctx.stop.getStopIndex() + 1));
    }

    public FileObject getFileObject() {
        return this.source.getSource().getFileObject();
    }

    public Optional<OffsetRange> getOffsetRange(HCLElement e) {
        return Optional.ofNullable(this.elementOffsets.get(e));
    }

    public List<? extends HCLElement> elementsAt(int index) {
        Map.Entry<OffsetRange, HCLElement> e;
        OffsetRange or;
        if (index < 0) {
            return Collections.emptyList();
        }
        LinkedList<HCLElement> ret = new LinkedList<HCLElement>();
        Iterator<Map.Entry<OffsetRange, HCLElement>> it = this.elementAt.entrySet().iterator();
        while (it.hasNext() && (or = (e = it.next()).getKey()).getStart() <= index) {
            if (or.getEnd() <= index) continue;
            ret.add(e.getValue());
        }
        return ret.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(ret);
    }
}

