/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLContainer;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLExpressionFactory;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.grammar.HCLParser;

public class HCLBlockFactory {
    private final Consumer<HCLElement.CreateContext> createAction;
    private final HCLExpressionFactory exprFactory;
    private int group = 0;
    private ParserRuleContext prev = null;

    public HCLBlockFactory(Consumer<HCLElement.CreateContext> createAction) {
        this.createAction = createAction;
        this.exprFactory = new HCLExpressionFactory(createAction);
    }

    public HCLBlockFactory() {
        this(null);
    }

    public final HCLDocument process(HCLParser.ConfigFileContext ctx) {
        HCLDocument ret = new HCLDocument();
        if (ctx.body() != null) {
            this.body(ret, ctx.body());
        }
        return ret;
    }

    protected HCLBlock block(HCLContainer parent, HCLParser.BlockContext ctx) {
        HCLBlock ret = this.created(new HCLBlock(parent), ctx);
        if (ctx.body() != null) {
            this.body(ret, ctx.body());
        }
        ArrayList<HCLIdentifier> decl = new ArrayList<HCLIdentifier>(4);
        if (ctx.children != null) {
            for (ParseTree pt : ctx.children) {
                HCLParser.StringLitContext slit;
                String sid;
                Token token;
                if (pt instanceof TerminalNode && (token = ((TerminalNode)pt).getSymbol()).getType() == 40) {
                    HCLIdentifier attrName = this.created(new HCLIdentifier.SimpleId(token.getText()), token);
                    if (pt instanceof ErrorNode) {
                        if (this.prev != null) {
                            this.group += this.prev.stop.getLine() + 1 < token.getLine() ? 1 : 0;
                        }
                        HCLAttribute attr = this.created(new HCLAttribute(ret, attrName, null, this.group), token);
                        ret.add(attr);
                    } else {
                        decl.add(attrName);
                    }
                }
                if (!(pt instanceof HCLParser.StringLitContext) || (sid = (slit = (HCLParser.StringLitContext)pt).getText()).length() <= 1) continue;
                sid = sid.substring(1, sid.length() - (sid.endsWith("\"") ? 1 : 0));
                HCLIdentifier id = this.created(new HCLIdentifier.StringId(sid), slit);
                decl.add(id);
            }
        }
        ret.setDeclaration(decl);
        return ret;
    }

    protected void body(HCLContainer c, HCLParser.BodyContext ctx) {
        if (ctx.children != null) {
            for (ParseTree pt : ctx.children) {
                Token token;
                HCLIdentifier attrName;
                if (pt instanceof HCLParser.AttributeContext) {
                    HCLParser.AttributeContext actx = (HCLParser.AttributeContext)pt;
                    if (this.prev != null) {
                        this.group += this.prev.stop.getLine() + 1 < actx.start.getLine() ? 1 : 0;
                    }
                    attrName = this.created(new HCLIdentifier.SimpleId(actx.IDENTIFIER().getText()), actx.IDENTIFIER().getSymbol());
                    HCLExpression attrValue = this.exprFactory.process(actx.expression());
                    HCLAttribute attr = this.created(new HCLAttribute(c, attrName, attrValue, this.group), actx);
                    c.add(attr);
                    this.prev = actx;
                    continue;
                }
                if (pt instanceof HCLParser.BlockContext) {
                    c.add(this.block(c, (HCLParser.BlockContext)pt));
                    continue;
                }
                if (!(pt instanceof ErrorNode) || (token = ((ErrorNode)pt).getSymbol()).getType() != 40) continue;
                if (this.prev != null) {
                    this.group += this.prev.stop.getLine() + 1 < token.getLine() ? 1 : 0;
                }
                attrName = this.created(new HCLIdentifier.SimpleId(token.getText()), token);
                HCLAttribute attr = new HCLAttribute(c, attrName, null, this.group);
                c.add(attr);
            }
        }
    }

    private <E extends HCLElement> E created(E element, Token token) {
        this.elementCreated(element, token, token);
        return element;
    }

    private <E extends HCLElement> E created(E element, ParserRuleContext ctx) {
        this.elementCreated(element, ctx.start, ctx.stop);
        return element;
    }

    private void elementCreated(HCLElement element, Token start, Token stop) {
        if (this.createAction != null) {
            this.createAction.accept(new HCLElement.CreateContext(element, start, stop));
        }
    }
}

