/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.j2ee;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.junit.NbModuleSuite;

public class J2eeTestCase
extends JellyTestCase {
    private static final String PID_FILE_PREFIX = "J2EE_TEST_CASE_PID_FILE";
    private static final String JBOSS_PATH = "org.netbeans.modules.j2ee.jboss4.installRoot";
    private static final String GLASSFISH_HOME = "glassfish.home";
    private static final String TOMCAT_HOME = "tomcat.home";
    private static final String JBOSS_HOME = "jboss.home";
    private static final Logger LOG = Logger.getLogger(J2eeTestCase.class.getName());
    private static boolean serversLogged = false;
    private static List<Server> alreadyRegistered = new ArrayList<Server>();
    private static boolean addServerTestsCalled = false;
    static boolean isSelfTest = false;

    public J2eeTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createPid();
    }

    private void createPid() throws IOException {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        pid = pid.substring(0, pid.indexOf(64));
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirPath);
        for (String file : tmpDir.list()) {
            if (!file.startsWith(PID_FILE_PREFIX) || new File(tmpDir, file).delete()) continue;
            LOG.log(Level.WARNING, "File ''{0}{1}{2}'' not successfully deleted!", new Object[]{tmpDirPath, File.pathSeparator, file});
        }
        if (!new File(tmpDir, PID_FILE_PREFIX + pid).createNewFile()) {
            LOG.log(Level.WARNING, "File ''{0}{1}J2EE_TEST_CASE_PID_FILE{2}'' not successfully created!", new Object[]{tmpDirPath, File.pathSeparator, pid});
        }
    }

    private static void registerJBoss() {
        String jbossPath = J2eeTestCase.getServerHome(Server.JBOSS);
        if (J2eeTestCase.isValidPath(jbossPath)) {
            LOG.log(Level.INFO, "Setting server path {0}", jbossPath);
            System.setProperty(JBOSS_PATH, jbossPath);
            alreadyRegistered.add(Server.JBOSS);
        }
    }

    private static String getServerHome(Server server) {
        switch (server) {
            case JBOSS: {
                return System.getProperty(JBOSS_HOME);
            }
            case GLASSFISH: {
                return System.getProperty(GLASSFISH_HOME);
            }
            case TOMCAT: {
                return System.getProperty(TOMCAT_HOME);
            }
        }
        return null;
    }

    private static boolean isValidPath(String path) {
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (f.isDirectory()) {
            LOG.log(Level.FINE, "{0} - is valid directory", path);
            return true;
        }
        if (!f.exists()) {
            LOG.log(Level.INFO, "{0} - does not exists!", path);
        } else {
            LOG.log(Level.INFO, "{0} - exists, but it is not a directory!", path);
        }
        return false;
    }

    protected static Test createAllModulesServerSuite(Server server, Class<? extends TestCase> clazz, String ... testNames) {
        NbModuleSuite.Configuration result = NbModuleSuite.createConfiguration(clazz);
        result = J2eeTestCase.addServerTests(server, result, testNames).enableModules(".*").clusters(".*").honorAutoloadEager(true);
        return result.suite();
    }

    protected static NbModuleSuite.Configuration addServerTests(NbModuleSuite.Configuration conf, String ... testNames) {
        return J2eeTestCase.addServerTests(Server.ANY, conf, testNames);
    }

    protected static NbModuleSuite.Configuration addServerTests(Server server, NbModuleSuite.Configuration conf, String ... testNames) {
        return J2eeTestCase.addServerTests(server, conf, null, testNames);
    }

    protected static NbModuleSuite.Configuration addServerTests(Server server, NbModuleSuite.Configuration conf, Class<? extends TestCase> clazz, String ... testNames) {
        addServerTestsCalled = true;
        if (J2eeTestCase.isRegistered(server)) {
            LOG.info("adding server tests");
            return J2eeTestCase.addTest(conf, clazz, testNames);
        }
        if (server == Server.GLASSFISH || server == Server.ANY) {
            J2eeTestCase.registerGlassFish();
            if (J2eeTestCase.isRegistered(Server.GLASSFISH)) {
                return J2eeTestCase.addTest(conf, clazz, testNames);
            }
        }
        if (server == Server.TOMCAT || server == Server.ANY) {
            J2eeTestCase.registerTomcat();
            if (J2eeTestCase.isRegistered(Server.TOMCAT)) {
                return J2eeTestCase.addTest(conf, clazz, testNames);
            }
        }
        if (server == Server.JBOSS || server == Server.ANY) {
            J2eeTestCase.registerJBoss();
            if (J2eeTestCase.isRegistered(Server.JBOSS)) {
                return J2eeTestCase.addTest(conf, clazz, testNames);
            }
        }
        LOG.info("no server to add tests");
        if (!serversLogged) {
            serversLogged = true;
            LOG.log(Level.INFO, "{0}={1}", new String[]{JBOSS_HOME, J2eeTestCase.getServerHome(Server.JBOSS)});
            LOG.log(Level.INFO, "{0}={1}", new String[]{TOMCAT_HOME, J2eeTestCase.getServerHome(Server.TOMCAT)});
            LOG.log(Level.INFO, "{0}={1}", new String[]{GLASSFISH_HOME, J2eeTestCase.getServerHome(Server.GLASSFISH)});
        }
        try {
            return conf.addTest(new String[]{"testEmpty"});
        }
        catch (IllegalStateException exc) {
            return conf.addTest(J2eeTestCase.class, new String[]{"testEmpty"});
        }
    }

    protected static boolean isRegistered(Server server) {
        if (!addServerTestsCalled) {
            throw new IllegalStateException("Cannot call isRegistered here. It is allowed only in suite method after addServerTests is called.");
        }
        if (server == Server.ANY) {
            return !alreadyRegistered.isEmpty();
        }
        return alreadyRegistered.contains((Object)server);
    }

    protected J2eeServerNode getServerNode(Server server) {
        switch (server) {
            case GLASSFISH: {
                return J2eeServerNode.invoke("GlassFish");
            }
            case JBOSS: {
                return J2eeServerNode.invoke("JBoss");
            }
            case TOMCAT: {
                return J2eeServerNode.invoke("Tomcat");
            }
            case ANY: {
                for (Server serv : Server.values()) {
                    if (serv == Server.ANY) continue;
                    try {
                        return this.getServerNode(serv);
                    }
                    catch (JemmyException jemmyException) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("No server is registred in IDE");
            }
        }
        throw new IllegalArgumentException("Unsupported server");
    }

    public void testEmpty() {
    }

    private static NbModuleSuite.Configuration addTest(NbModuleSuite.Configuration conf, Class<? extends TestCase> clazz, String ... testNames) {
        if (clazz == null) {
            if (testNames == null || testNames.length == 0) {
                return conf;
            }
            return conf.addTest(testNames);
        }
        return conf.addTest(clazz, testNames);
    }

    protected void resolveServer(String projectName) {
        this.waitScanFinished();
        String openProjectTitle = Bundle.getString((String)"org.netbeans.modules.j2ee.common.ui.Bundle", (String)"MSG_Broken_Server_Title");
        if (JDialogOperator.findJDialog((String)openProjectTitle, (boolean)true, (boolean)true) != null) {
            new NbDialogOperator(openProjectTitle).close();
            LOG.info("Resolving server");
            ProjectsTabOperator.invoke().getProjectRootNode(projectName).properties();
            String projectPropertiesTitle = Bundle.getStringTrimmed((String)"org.netbeans.modules.web.project.ui.customizer.Bundle", (String)"LBL_Customizer_Title");
            NbDialogOperator propertiesDialogOper = new NbDialogOperator(projectPropertiesTitle);
            new Node(new JTreeOperator((ContainerOperator)propertiesDialogOper), "Run").select();
            new JComboBoxOperator((ContainerOperator)propertiesDialogOper).setSelectedIndex(0);
            propertiesDialogOper.ok();
            this.waitScanFinished();
        }
    }

    private static void registerGlassFish() {
        String glassFishHome = J2eeTestCase.getServerHome(Server.GLASSFISH);
        if (!J2eeTestCase.isValidPath(glassFishHome) || !J2eeTestCase.isValidPath(glassFishHome + "/glassfish/domains/domain1")) {
            LOG.log(Level.WARNING, "Valid GlassFish server not found at path {0}", glassFishHome);
            return;
        }
        LOG.log(Level.INFO, "Registering GlassFish server at {0}", glassFishHome);
        if (isSelfTest) {
            alreadyRegistered.add(Server.GLASSFISH);
            return;
        }
        try {
            int result = J2eeTestCase.registerServer(Server.GLASSFISH, "org.netbeans.modules.glassfish.common.registration.AutomaticRegistration", J2eeTestCase.findCluster("enterprise"), glassFishHome + "/glassfish");
            if (result != 0) {
                LOG.log(Level.WARNING, "registerServer in separate JVM failed with status {0}. Trying to register server within this JVM but it can influence test cases by loading classes too early", result);
                Class<?> regClass = Class.forName("org.netbeans.modules.glassfish.common.registration.AutomaticRegistration", true, J2eeTestCase.getLoader(Server.GLASSFISH));
                Method method = regClass.getDeclaredMethod("autoregisterGlassFishInstance", String.class, String.class, String.class);
                method.setAccessible(true);
                result = (Integer)method.invoke(null, J2eeTestCase.findCluster("enterprise"), glassFishHome + "/glassfish", "");
            }
            if (result == 0) {
                alreadyRegistered.add(Server.GLASSFISH);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Registering GlassFish server failed.", ex);
        }
    }

    private static void registerTomcat() {
        String tomcatHome = J2eeTestCase.getServerHome(Server.TOMCAT);
        if (!J2eeTestCase.isValidPath(tomcatHome)) {
            LOG.log(Level.WARNING, "Valid Tomcat server not found at path {0}", tomcatHome);
            return;
        }
        LOG.log(Level.INFO, "Registering Tomcat server at {0}", tomcatHome);
        if (isSelfTest) {
            alreadyRegistered.add(Server.TOMCAT);
            return;
        }
        try {
            int result = J2eeTestCase.registerServer(Server.TOMCAT, "org.netbeans.modules.tomcat5.registration.AutomaticRegistration", J2eeTestCase.findCluster("enterprise"), tomcatHome);
            if (result != 0) {
                Class<?> regClass = Class.forName("org.netbeans.modules.tomcat5.registration.AutomaticRegistration", true, J2eeTestCase.getLoader(Server.TOMCAT));
                Method method = regClass.getDeclaredMethod("registerTomcatInstance", String.class, String.class);
                method.setAccessible(true);
                result = (Integer)method.invoke(null, J2eeTestCase.findCluster("enterprise"), tomcatHome);
            }
            if (result == 0) {
                alreadyRegistered.add(Server.TOMCAT);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Registering Tomcat server failed.", ex);
        }
    }

    private static String getClassPath(Server server) {
        StringBuilder sb = new StringBuilder();
        for (File file : J2eeTestCase.getJars(server)) {
            sb.append(file.getAbsolutePath());
            sb.append(File.pathSeparatorChar);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static URLClassLoader getLoader(Server server) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : J2eeTestCase.getJars(server)) {
            urls.add(file.toURI().toURL());
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        return loader;
    }

    private static List<File> getJars(Server server) {
        ArrayList<File> jars = new ArrayList<File>();
        jars.add(new File(J2eeTestCase.findCluster("platform"), "core/core-base.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "core/core.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "lib/boot.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "lib/org-openide-modules.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "core/org-openide-filesystems.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "lib/org-openide-util.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "lib/org-openide-util-base.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "lib/org-openide-util-lookup.jar"));
        jars.add(new File(J2eeTestCase.findCluster("platform"), "lib/org-openide-util-ui.jar"));
        jars.add(new File(J2eeTestCase.findCluster("enterprise"), "modules/org-netbeans-modules-j2eeapis.jar"));
        jars.add(new File(J2eeTestCase.findCluster("enterprise"), "modules/org-netbeans-modules-j2eeserver.jar"));
        if (server == Server.GLASSFISH) {
            jars.add(new File(J2eeTestCase.findCluster("enterprise"), "modules/org-netbeans-modules-glassfish-common.jar"));
            jars.add(new File(J2eeTestCase.findCluster("enterprise"), "modules/org-netbeans-modules-glassfish-tooling.jar"));
        } else if (server == Server.TOMCAT) {
            jars.add(new File(J2eeTestCase.findCluster("enterprise"), "modules/org-netbeans-modules-tomcat5.jar"));
        }
        return jars;
    }

    private static int registerServer(Server server, String mainClass, String clusterDir, String serverHome) throws Exception {
        String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(jvm);
        command.add("-cp");
        command.add(J2eeTestCase.getClassPath(server));
        command.add(mainClass);
        command.add(clusterDir);
        command.add(serverHome);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.start();
        int result = process.waitFor();
        return result;
    }

    private static String findCluster(String clusterName) {
        String clusters = System.getProperty("cluster.path.final");
        assert (clusters != null) : "cluster.path.final must be set.";
        for (String cluster : J2eeTestCase.tokenizePath(clusters)) {
            if (!cluster.endsWith(clusterName)) continue;
            return cluster;
        }
        return null;
    }

    private static String[] tokenizePath(String path) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, ":;", true);
        char dosHack = '\u0000';
        int lastDelim = 0;
        int delimCount = 0;
        while (tok.hasMoreTokens()) {
            char c;
            String s = tok.nextToken();
            if (s.length() == 0) continue;
            if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                lastDelim = c;
                ++delimCount;
                continue;
            }
            if (dosHack != '\u0000') {
                if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                    s = "" + dosHack + ':' + s;
                } else {
                    l.add(Character.toString(dosHack));
                }
                dosHack = '\u0000';
            }
            delimCount = 0;
            if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                dosHack = c;
                continue;
            }
            l.add(s);
        }
        if (dosHack != '\u0000') {
            l.add(Character.toString(dosHack));
        }
        return l.toArray(new String[l.size()]);
    }

    public static enum Server {
        TOMCAT,
        GLASSFISH,
        JBOSS,
        ANY;

    }
}

