/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.spi.language.support;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.util.ChangeSupport;

public class MultiTokenList {
    public static TokenList create(List<TokenList> l) {
        return new MultiTokenListImpl(l);
    }

    private static final class MultiTokenListImpl
    implements TokenList,
    ChangeListener {
        private List<TokenList> delegateTo;
        private List<Boolean> moved;
        private int currentOffset;
        private CharSequence currentWord;
        private ChangeSupport cs = new ChangeSupport((Object)this);

        public MultiTokenListImpl(List<TokenList> delegateTo) {
            this.delegateTo = delegateTo;
            this.moved = new ArrayList<Boolean>(delegateTo.size());
            for (TokenList l : delegateTo) {
                l.addChangeListener(this);
            }
        }

        @Override
        public void setStartOffset(int offset) {
            this.moved.clear();
            for (TokenList l : this.delegateTo) {
                l.setStartOffset(offset);
                this.moved.add(l.nextWord());
            }
        }

        @Override
        public boolean nextWord() {
            TokenList first = null;
            int firstOffset = Integer.MAX_VALUE;
            int firstIndex = 0;
            int index = 0;
            for (TokenList l : this.delegateTo) {
                if (this.moved.get(index).booleanValue() && l.getCurrentWordStartOffset() < firstOffset) {
                    firstOffset = l.getCurrentWordStartOffset();
                    first = l;
                    firstIndex = index;
                }
                ++index;
            }
            if (first != null) {
                this.currentOffset = firstOffset;
                this.currentWord = first.getCurrentWordText();
                this.moved.set(firstIndex, first.nextWord());
                return true;
            }
            return false;
        }

        @Override
        public int getCurrentWordStartOffset() {
            return this.currentOffset;
        }

        @Override
        public CharSequence getCurrentWordText() {
            return this.currentWord;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }
    }
}

