/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.method.InjectionPointParameterAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.method.InterceptedMethodAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.method.ScopedMethodAnalyzer;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;

public class MethodModelAnalyzer
implements ModelAnalyzer {
    private static final List<MethodAnalyzer> ANALYZERS = new LinkedList<MethodAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        ExecutableElement method = (ExecutableElement)element;
        TypeMirror methodType = model.getCompilationController().getTypes().asMemberOf((DeclaredType)parent.asType(), method);
        if (methodType instanceof ExecutableType) {
            if (cancel.get()) {
                return;
            }
            TypeMirror returnType = ((ExecutableType)methodType).getReturnType();
            for (MethodAnalyzer analyzer : ANALYZERS) {
                if (cancel.get()) {
                    return;
                }
                analyzer.analyze(method, returnType, parent, model, cancel, result);
            }
        }
    }

    static {
        ANALYZERS.add(new ScopedMethodAnalyzer());
        ANALYZERS.add(new InjectionPointParameterAnalyzer());
        ANALYZERS.add(new InterceptedMethodAnalyzer());
    }

    public static interface MethodAnalyzer {
        public void analyze(ExecutableElement var1, TypeMirror var2, TypeElement var3, WebBeansModel var4, AtomicBoolean var5, ModelAnalyzer.Result var6);
    }
}

