/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AbstractScopedAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.CdiAnnotationAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.StereotypeVerifier;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.TargetAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.TargetVerifier;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.impl.model.WebBeansModelProviderImpl;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class StereotypeAnalyzer
extends AbstractScopedAnalyzer
implements AnnotationModelAnalyzer.AnnotationAnalyzer {
    @Override
    public void analyze(TypeElement element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        boolean isStereotype = AnnotationUtil.hasAnnotation(element, "jakarta.enterprise.inject.Stereotype", (CompilationInfo)model.getCompilationController());
        if (!isStereotype) {
            return;
        }
        result.requireCdiEnabled(element, model);
        if (cancel.get()) {
            return;
        }
        this.analyzeScope(element, model, cancel, result);
        if (cancel.get()) {
            return;
        }
        this.checkName(element, model, result);
        if (cancel.get()) {
            return;
        }
        Set<ElementType> targets = this.checkDefinition(element, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkInterceptorBindings(element, targets, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkTransitiveStereotypes(element, targets, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkTyped(element, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkQualifers(element, model, result);
    }

    private void checkQualifers(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        List<AnnotationMirror> qualifiers = model.getQualifiers(element, true);
        for (AnnotationMirror annotationMirror : qualifiers) {
            Element annotation = annotationMirror.getAnnotationType().asElement();
            if (annotation instanceof TypeElement && ((TypeElement)annotation).getQualifiedName().contentEquals("jakarta.inject.Named")) continue;
            result.addNotification(Severity.WARNING, (Element)element, model, NbBundle.getMessage(StereotypeAnalyzer.class, (String)"WARN_QualifiedStereotype"));
            break;
        }
    }

    private void checkTyped(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        AnnotationMirror typed = AnnotationUtil.getAnnotationMirror((Element)element, (CompilationInfo)model.getCompilationController(), "jakarta.enterprise.inject.Typed");
        if (typed != null) {
            result.addNotification(Severity.WARNING, (Element)element, model, NbBundle.getMessage(StereotypeAnalyzer.class, (String)"WARN_TypedStereotype"));
        }
    }

    private void checkTransitiveStereotypes(TypeElement element, Set<ElementType> targets, WebBeansModel model, ModelAnalyzer.Result result) {
        AnnotationHelper helper = new AnnotationHelper((CompilationInfo)model.getCompilationController());
        List<AnnotationMirror> stereotypes = WebBeansModelProviderImpl.getAllStereotypes(element, helper);
        for (AnnotationMirror stereotypeAnnotation : stereotypes) {
            TypeElement stereotype;
            Set<ElementType> declaredTargetTypes;
            Element annotationElement = stereotypeAnnotation.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement) || (declaredTargetTypes = TargetAnalyzer.getDeclaredTargetTypes(helper, stereotype = (TypeElement)annotationElement)) == null || declaredTargetTypes.size() != 1 || !declaredTargetTypes.contains((Object)ElementType.TYPE) || targets.size() == 1 && targets.contains((Object)ElementType.TYPE)) continue;
            String fqn = stereotype.getQualifiedName().toString();
            result.addError((Element)element, model, NbBundle.getMessage(StereotypeAnalyzer.class, (String)"ERR_IncorrectTransitiveTarget", (Object)fqn));
        }
    }

    private void checkInterceptorBindings(TypeElement element, Set<ElementType> targets, WebBeansModel model, ModelAnalyzer.Result result) {
        if (targets == null) {
            return;
        }
        if (targets.size() == 1 && targets.contains((Object)ElementType.TYPE)) {
            return;
        }
        int interceptorsCount = model.getInterceptorBindings(element).size();
        if (interceptorsCount != 0) {
            result.addError((Element)element, model, NbBundle.getMessage(StereotypeAnalyzer.class, (String)"ERR_IncorrectTargetWithInterceptorBindings"));
        }
    }

    private Set<ElementType> checkDefinition(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        StereotypeTargetAnalyzer analyzer = new StereotypeTargetAnalyzer(element, model, result);
        if (!analyzer.hasRuntimeRetention()) {
            result.addError((Element)element, model, NbBundle.getMessage(StereotypeAnalyzer.class, (String)"ERR_IncorrectRuntimeRetention"));
        }
        if (!analyzer.hasTarget()) {
            result.addError((Element)element, model, NbBundle.getMessage(StereotypeAnalyzer.class, (String)"ERR_IncorrectStereotypeTarget"));
            return null;
        }
        return analyzer.getDeclaredTargetTypes();
    }

    private void checkName(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        AnnotationMirror named = AnnotationUtil.getAnnotationMirror((Element)element, "jakarta.inject.Named", (CompilationInfo)model.getCompilationController());
        if (named == null) {
            return;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> members = named.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : members.entrySet()) {
            ExecutableElement member = entry.getKey();
            if (!member.getSimpleName().contentEquals("value")) continue;
            result.addError((Element)element, model, NbBundle.getMessage(StereotypeAnalyzer.class, (String)"ERR_NonEmptyNamedStereotype"));
        }
    }

    @Override
    protected void checkScope(TypeElement scopeElement, Element element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
    }

    private static class StereotypeTargetAnalyzer
    extends CdiAnnotationAnalyzer {
        StereotypeTargetAnalyzer(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
            super(element, model, result);
        }

        @Override
        protected String getCdiMetaAnnotation() {
            return "Stereotype";
        }

        @Override
        protected TargetVerifier getTargetVerifier() {
            return StereotypeVerifier.getInstance();
        }
    }
}

