/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.jakarta.web.beans.completion.CCPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public abstract class BeansCompletionItem
implements CompletionItem {
    protected int substituteOffset = -1;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;

    static BeansCompletionItem createBeansTagValueItem(int substitutionOffset, String fullName, String simpleName) {
        return new TagClassValueItem(substitutionOffset, fullName, simpleName);
    }

    public abstract String getItemText();

    public String getSubstitutionText() {
        return this.getItemText();
    }

    public int getSubstituteOffset() {
        return this.substituteOffset;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shifted) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = this.getSubstitutionText();
        if (text != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                text = text + toAdd;
            }
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) {
                    boolean bl = false;
                    return bl;
                }
                if (!shifted) {
                    char ch;
                    if (!text.startsWith("\"")) {
                        text = this.quoteText(text);
                    }
                    if ((ch = doc.getText(offset + len, 1).charAt(0)) == '\"') {
                        ++len;
                    }
                }
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public boolean canFilter() {
        return true;
    }

    public boolean cutomPosition() {
        return false;
    }

    public int getCutomPosition() {
        return -1;
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    public abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public String toString() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            Completion completion = Completion.get();
            switch (evt.getKeyChar()) {
                case ' ': {
                    if (evt.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
            }
        }
    }

    protected String quoteText(String s) {
        return "\"" + s + "\"";
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent c) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(c);
        return true;
    }

    public void defaultAction(JTextComponent component) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(component, "");
    }

    private boolean defaultAction(JTextComponent component, String addText) {
        int substOffset = this.substituteOffset;
        if (substOffset == -1) {
            substOffset = component.getCaret().getDot();
        }
        toAdd = addText;
        return this.substituteText(component, substOffset, component.getCaret().getDot() - substOffset, false);
    }

    private static class TagClassValueItem
    extends BeansXmlCompletionItem {
        private final String displayText;
        private final String simpleName;
        CCPaintComponent.DBElementPaintComponent paintComponent;

        public TagClassValueItem(int substitutionOffset, String fullName, String simpleName) {
            super(substitutionOffset);
            this.displayText = fullName;
            this.simpleName = simpleName;
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public CharSequence getSortText() {
            return this.displayText;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.simpleName + (this.simpleName.length() < this.displayText.length() ? " (" + this.displayText.substring(0, this.displayText.length() - this.simpleName.length() - 1) + ")" : "");
        }

        @Override
        protected String getLeftHtmlText() {
            return this.getDisplayText();
        }

        @Override
        public String getItemText() {
            return this.getDisplayText();
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (this.paintComponent == null) {
                this.paintComponent = new CCPaintComponent.DBElementPaintComponent();
            }
            this.paintComponent.setString(this.getDisplayText());
            this.paintComponent.setSelected(isSelected);
            return this.paintComponent;
        }
    }

    private static abstract class BeansXmlCompletionItem
    extends BeansCompletionItem {
        protected int substitutionOffset;

        protected BeansXmlCompletionItem(int substitutionOffset) {
            this.substitutionOffset = substitutionOffset;
        }

        @Override
        public void defaultAction(JTextComponent component) {
            if (component != null) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            CharSequence prefix = this.getInsertPrefix();
            String text = prefix.toString();
            if (toAdd != null) {
                text = text + toAdd;
            }
            doc.atomicLock();
            try {
                Position position = doc.createPosition(offset);
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), text.toString(), null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                doc.atomicUnlock();
            }
        }

        @Override
        public String getSubstitutionText() {
            return this.getInsertPrefix().toString();
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
        }

        @Override
        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return null;
        }

        @Override
        public CompletionTask createToolTipTask() {
            return null;
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            this.defaultAction(component);
            return true;
        }

        protected String getLeftHtmlText() {
            return null;
        }

        protected String getRightHtmlText() {
            return null;
        }

        protected ImageIcon getIcon() {
            return null;
        }

        public abstract String getDisplayText();
    }
}

