/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.DefaultProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ValueProvider;
import org.openide.util.Parameters;

public final class AnnotationParser {
    private static final Set<Class<?>> PRIMITIVE_WRAPPERS = new HashSet();
    private final Map<String, ValueProvider> providers = new HashMap<String, ValueProvider>();
    private final AnnotationHelper helper;

    public static DefaultProvider defaultValue(Object defaultValue) {
        return new DefaultProviderImpl(defaultValue);
    }

    public static AnnotationParser create(AnnotationModelHelper helper) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        return new AnnotationParser(helper.getHelper());
    }

    public static AnnotationParser create(AnnotationHelper helper) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        return new AnnotationParser(helper);
    }

    private AnnotationParser(AnnotationHelper helper) {
        this.helper = helper;
    }

    public <T> void expectPrimitive(String name, Class<T> type, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"type", type);
        if (!PRIMITIVE_WRAPPERS.contains(type)) {
            throw new IllegalArgumentException(type + " is not a primitive wrapper class");
        }
        this.addProvider(name, new PrimitiveValueProvider(type, defaultProvider));
    }

    public void expectString(String name, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.addProvider(name, new PrimitiveValueProvider(String.class, defaultProvider));
    }

    public void expectClass(String name, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.addProvider(name, new ClassValueProvider(defaultProvider));
    }

    public void expectEnumConstant(String name, TypeMirror enumType, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"enumType", (Object)enumType);
        this.addProvider(name, new EnumConstantValueProvider(enumType, defaultProvider));
    }

    public void expectAnnotation(String name, TypeMirror annotationType, AnnotationValueHandler handler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"annotationType", (Object)annotationType);
        Parameters.notNull((CharSequence)"handler", (Object)handler);
        this.addProvider(name, new AnnotationValueProvider(annotationType, handler, defaultProvider));
    }

    public void expectPrimitiveArray(String name, Class<?> type, ArrayValueHandler handler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"type", type);
        Parameters.notNull((CharSequence)"handler", (Object)handler);
        this.addProvider(name, new PrimitiveArrayValueProvider(type, handler, defaultProvider));
    }

    public void expectStringArray(String name, ArrayValueHandler handler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"handler", (Object)handler);
        this.addProvider(name, new PrimitiveArrayValueProvider(String.class, handler, defaultProvider));
    }

    public void expectClassArray(String name, ArrayValueHandler handler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"handler", (Object)handler);
        this.addProvider(name, new ClassArrayValueProvider(handler, defaultProvider));
    }

    public void expectEnumConstantArray(String name, TypeMirror enumType, ArrayValueHandler handler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"enumType", (Object)enumType);
        Parameters.notNull((CharSequence)"handler", (Object)handler);
        this.addProvider(name, new EnumConstantArrayValueProvider(enumType, handler, defaultProvider));
    }

    public void expectAnnotationArray(String name, TypeMirror annotationType, ArrayValueHandler handler, DefaultProvider defaultProvider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"annotationType", (Object)annotationType);
        Parameters.notNull((CharSequence)"handler", (Object)handler);
        this.addProvider(name, new AnnotationArrayValueProvider(annotationType, handler, defaultProvider));
    }

    public void expect(String name, ValueProvider provider) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.addProvider(name, provider);
    }

    public ParseResult parse(AnnotationMirror annotation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (annotation != null) {
            for (Map.Entry<Object, Object> entry : annotation.getElementValues().entrySet()) {
                Object value;
                ExecutableElement element = (ExecutableElement)entry.getKey();
                String name = element.getSimpleName().toString();
                ValueProvider provider = this.providers.get(name);
                if (provider == null || (value = provider.getValue((AnnotationValue)entry.getValue())) == null) continue;
                result.put(name, value);
            }
        }
        for (Map.Entry<Object, Object> entry : this.providers.entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            if (result.containsKey(name) || (value = ((ValueProvider)entry.getValue()).getDefaultValue()) == null) continue;
            result.put(name, value);
        }
        return new ParseResult(result);
    }

    private void addProvider(String name, ValueProvider provider) {
        if (this.providers.containsKey(name)) {
            throw new IllegalArgumentException("There is already a provider for element name '" + name + "'");
        }
        this.providers.put(name, provider);
    }

    static {
        PRIMITIVE_WRAPPERS.add(Boolean.class);
        PRIMITIVE_WRAPPERS.add(Byte.class);
        PRIMITIVE_WRAPPERS.add(Short.class);
        PRIMITIVE_WRAPPERS.add(Integer.class);
        PRIMITIVE_WRAPPERS.add(Long.class);
        PRIMITIVE_WRAPPERS.add(Character.class);
        PRIMITIVE_WRAPPERS.add(Float.class);
        PRIMITIVE_WRAPPERS.add(Double.class);
    }

    private final class AnnotationArrayValueProvider
    extends TypeCheckingArrayValueProvider {
        public AnnotationArrayValueProvider(TypeMirror annotationType, ArrayValueHandler handler, DefaultProvider defaultProvider) {
            super(annotationType, handler, defaultProvider);
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> arrayMembers) {
            for (AnnotationValue arrayMember : arrayMembers) {
                Object value = arrayMember.getValue();
                if (!(value instanceof AnnotationMirror)) {
                    return false;
                }
                AnnotationMirror annotation = (AnnotationMirror)value;
                if (this.isSameAsTypeToCheck(annotation.getAnnotationType())) continue;
                return false;
            }
            return true;
        }
    }

    private final class EnumConstantArrayValueProvider
    extends TypeCheckingArrayValueProvider {
        public EnumConstantArrayValueProvider(TypeMirror enumType, ArrayValueHandler handler, DefaultProvider defaultProvider) {
            super(enumType, handler, defaultProvider);
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> arrayMembers) {
            for (AnnotationValue arrayMember : arrayMembers) {
                Object value = arrayMember.getValue();
                if (!(value instanceof VariableElement)) {
                    return false;
                }
                VariableElement field = (VariableElement)value;
                TypeMirror enumType = field.getEnclosingElement().asType();
                if (this.isSameAsTypeToCheck(enumType)) continue;
                return false;
            }
            return true;
        }
    }

    private final class ClassArrayValueProvider
    extends DefaultArrayValueProvider {
        public ClassArrayValueProvider(ArrayValueHandler handler, DefaultProvider defaultProvider) {
            super(handler, defaultProvider);
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> arrayMembers) {
            for (AnnotationValue arrayMember : arrayMembers) {
                Object value = arrayMember.getValue();
                if (!(value instanceof TypeMirror)) {
                    return false;
                }
                TypeMirror type = (TypeMirror)value;
                if (TypeKind.DECLARED == type.getKind()) continue;
                return false;
            }
            return true;
        }
    }

    private final class PrimitiveArrayValueProvider
    extends DefaultArrayValueProvider {
        private final Class<?> type;

        public PrimitiveArrayValueProvider(Class<?> type, ArrayValueHandler handler, DefaultProvider defaultProvider) {
            super(handler, defaultProvider);
            this.type = type;
        }

        @Override
        protected boolean checkMembers(List<AnnotationValue> arrayMembers) {
            for (AnnotationValue arrayMember : arrayMembers) {
                Object value = arrayMember.getValue();
                if (this.type.isInstance(value)) continue;
                return false;
            }
            return true;
        }
    }

    private final class AnnotationValueProvider
    extends TypeCheckingValueProvider {
        private final AnnotationValueHandler handler;

        public AnnotationValueProvider(TypeMirror annotationType, AnnotationValueHandler handler, DefaultProvider defaultProvider) {
            super(annotationType, defaultProvider);
            this.handler = handler;
        }

        @Override
        public Object getValue(AnnotationValue elementValue) {
            Object result;
            AnnotationMirror annotation;
            Object value = elementValue.getValue();
            if (value instanceof AnnotationMirror && this.isSameAsTypeToCheck((annotation = (AnnotationMirror)value).getAnnotationType()) && (result = this.handler.handleAnnotation(annotation)) != null) {
                return result;
            }
            return this.getDefaultValue();
        }
    }

    private final class EnumConstantValueProvider
    extends TypeCheckingValueProvider {
        public EnumConstantValueProvider(TypeMirror enumType, DefaultProvider defaultProvider) {
            super(enumType, defaultProvider);
        }

        @Override
        public Object getValue(AnnotationValue elementValue) {
            VariableElement field;
            TypeMirror enumType;
            Object value = elementValue.getValue();
            if (value instanceof VariableElement && this.isSameAsTypeToCheck(enumType = (field = (VariableElement)value).getEnclosingElement().asType())) {
                return field.getSimpleName().toString();
            }
            return this.getDefaultValue();
        }
    }

    private final class ClassValueProvider
    extends DefaultValueProvider {
        public ClassValueProvider(DefaultProvider defaultProvider) {
            super(defaultProvider);
        }

        @Override
        public Object getValue(AnnotationValue elementValue) {
            TypeMirror type;
            Object value = elementValue.getValue();
            if (value instanceof TypeMirror && TypeKind.DECLARED == (type = (TypeMirror)value).getKind()) {
                return ((TypeElement)((DeclaredType)value).asElement()).getQualifiedName().toString();
            }
            return this.getDefaultValue();
        }
    }

    private class PrimitiveValueProvider
    extends DefaultValueProvider {
        private final Class<?> type;

        public PrimitiveValueProvider(Class<?> type, DefaultProvider defaultProvider) {
            super(defaultProvider);
            this.type = type;
        }

        @Override
        public Object getValue(AnnotationValue elementValue) {
            Object value = elementValue.getValue();
            if (this.type.isInstance(value)) {
                return value;
            }
            return this.getDefaultValue();
        }
    }

    private abstract class TypeCheckingArrayValueProvider
    extends TypeCheckingValueProvider {
        private final ArrayValueHandler handler;

        public TypeCheckingArrayValueProvider(TypeMirror typeToCheck, ArrayValueHandler handler, DefaultProvider defaultProvider) {
            super(typeToCheck, defaultProvider);
            this.handler = handler;
        }

        @Override
        public Object getValue(AnnotationValue elementValue) {
            Object result;
            List arrayMembers;
            Object value = elementValue.getValue();
            if (value instanceof List && this.checkMembers(arrayMembers = (List)value) && (result = this.handler.handleArray(arrayMembers)) != null) {
                return result;
            }
            return this.getDefaultValue();
        }

        protected abstract boolean checkMembers(List<AnnotationValue> var1);
    }

    private abstract class DefaultArrayValueProvider
    extends DefaultValueProvider {
        private final ArrayValueHandler handler;

        public DefaultArrayValueProvider(ArrayValueHandler handler, DefaultProvider defaultProvider) {
            super(defaultProvider);
            this.handler = handler;
        }

        @Override
        public Object getValue(AnnotationValue elementValue) {
            Object result;
            List arrayMembers;
            Object value = elementValue.getValue();
            if (value instanceof List && this.checkMembers(arrayMembers = (List)value) && (result = this.handler.handleArray(arrayMembers)) != null) {
                return result;
            }
            return this.getDefaultValue();
        }

        protected abstract boolean checkMembers(List<AnnotationValue> var1);
    }

    private abstract class TypeCheckingValueProvider
    extends DefaultValueProvider {
        private final TypeMirror typeToCheck;

        public TypeCheckingValueProvider(TypeMirror typeToCheck, DefaultProvider defaultProvider) {
            super(defaultProvider);
            this.typeToCheck = typeToCheck;
        }

        protected boolean isSameAsTypeToCheck(TypeMirror otherType) {
            return AnnotationParser.this.helper.getCompilationInfo().getTypes().isSameType(this.typeToCheck, otherType);
        }
    }

    private abstract class DefaultValueProvider
    implements ValueProvider {
        private final DefaultProvider defaultProvider;

        public DefaultValueProvider(DefaultProvider defaultProvider) {
            this.defaultProvider = defaultProvider;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultProvider != null ? this.defaultProvider.getDefaultValue() : null;
        }
    }

    private static final class DefaultProviderImpl
    implements DefaultProvider {
        private final Object defaultValue;

        public DefaultProviderImpl(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

