/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.Scoring;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateMatcher
extends BaseMatcher {
    private static final int DATE_MAX_YEAR = 2050;
    private static final int DATE_MIN_YEAR = 1000;
    private static final int[][][] DATE_SPLITS = new int[9][][];
    private static final Pattern MAYBE_DATE_NO_SEPARATOR = Pattern.compile("^\\d{4,8}$");
    private static final Pattern MAYBE_DATE_WITH_SEPARATOR = Pattern.compile("^(\\d{1,4})([\\s/\\\\_.-])(\\d{1,2})\\2(\\d{1,4})$");

    public DateMatcher(Context context) {
        super(context);
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        this.findDatesWithoutSeparator(password, matches);
        this.findDatesWithSeparator(password, matches);
        return this.filterSubMatches(matches);
    }

    private void findDatesWithoutSeparator(CharSequence password, List<Match> matches) {
        for (int startIndex = 0; startIndex <= password.length() - 4; ++startIndex) {
            for (int endIndex = startIndex + 3; endIndex <= startIndex + 7 && endIndex < password.length(); ++endIndex) {
                WipeableString token = WipeableString.copy(password, startIndex, endIndex + 1);
                if (!MAYBE_DATE_NO_SEPARATOR.matcher(token).find()) {
                    token.wipe();
                    continue;
                }
                this.extractDateCandidates(matches, startIndex, endIndex, token);
            }
        }
    }

    private void extractDateCandidates(List<Match> matches, int startIndex, int endIndex, WipeableString token) {
        List<Dmy> candidates = this.generateDateCandidates(token);
        if (candidates.isEmpty()) {
            token.wipe();
            return;
        }
        Dmy bestCandidate = this.selectBestDateCandidate(candidates);
        matches.add(MatchFactory.createDateMatch(startIndex, endIndex, token, "", bestCandidate.year, bestCandidate.month, bestCandidate.day));
    }

    private List<Dmy> generateDateCandidates(WipeableString token) {
        ArrayList<Dmy> candidates = new ArrayList<Dmy>();
        for (int[] date : DATE_SPLITS[token.length()]) {
            Dmy dmy;
            int[] extractedInts = this.extractIntsFromToken(token, date);
            if (extractedInts == null || (dmy = this.mapIntsToDmy(extractedInts)) == null) continue;
            candidates.add(dmy);
        }
        return candidates;
    }

    private int[] extractIntsFromToken(WipeableString token, int[] date) {
        int[] ints = new int[3];
        try {
            ints[0] = WipeableString.parseInt(token.subSequence(0, date[0]));
            ints[1] = WipeableString.parseInt(token.subSequence(date[0], date[1]));
            ints[2] = WipeableString.parseInt(token.subSequence(date[1], token.length()));
            return ints;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Dmy selectBestDateCandidate(List<Dmy> candidates) {
        Dmy bestCandidate = candidates.get(0);
        int minDistance = this.metric(candidates.get(0));
        for (Dmy candidate : candidates.subList(1, candidates.size())) {
            int distance = this.metric(candidate);
            if (distance >= minDistance) continue;
            bestCandidate = candidate;
            minDistance = distance;
        }
        return bestCandidate;
    }

    private void findDatesWithSeparator(CharSequence password, List<Match> matches) {
        for (int startIndex = 0; startIndex <= password.length() - 6; ++startIndex) {
            for (int endIndex = startIndex + 5; endIndex <= startIndex + 9 && endIndex < password.length(); ++endIndex) {
                WipeableString token = WipeableString.copy(password, startIndex, endIndex + 1);
                Matcher rxMatch = MAYBE_DATE_WITH_SEPARATOR.matcher(token);
                if (!rxMatch.find()) {
                    token.wipe();
                    continue;
                }
                int[] extractedInts = this.extractIntsFromMatcher(rxMatch);
                if (extractedInts == null) continue;
                Dmy dmy = this.mapIntsToDmy(extractedInts);
                if (dmy == null) {
                    token.wipe();
                    continue;
                }
                matches.add(MatchFactory.createDateMatch(startIndex, endIndex, token, rxMatch.group(2), dmy.year, dmy.month, dmy.day));
            }
        }
    }

    private int[] extractIntsFromMatcher(Matcher matcher) {
        int[] ints = new int[3];
        try {
            ints[0] = WipeableString.parseInt(matcher.group(1));
            ints[1] = WipeableString.parseInt(matcher.group(3));
            ints[2] = WipeableString.parseInt(matcher.group(4));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return ints;
    }

    private List<Match> filterSubMatches(List<Match> matches) {
        ArrayList<Match> targetMatches = new ArrayList<Match>();
        for (Match match : matches) {
            boolean isSubMatch = false;
            for (Match otherMatch : matches) {
                if (match.equals(otherMatch) || otherMatch.i > match.i || otherMatch.j < match.j) continue;
                isSubMatch = true;
                break;
            }
            if (isSubMatch) continue;
            targetMatches.add(match);
        }
        return this.sorted(targetMatches);
    }

    private int metric(Dmy candidate) {
        return Math.abs(candidate.year - Scoring.REFERENCE_YEAR);
    }

    private Dmy mapIntsToDmy(int[] ints) {
        int[][] possibleYearSplits;
        if (ints[1] > 31 || ints[1] <= 0) {
            return null;
        }
        int over12 = 0;
        int over31 = 0;
        int under1 = 0;
        for (int i : ints) {
            if (99 < i && i < 1000 || i > 2050) {
                return null;
            }
            if (i > 31) {
                ++over31;
            }
            if (i > 12) {
                ++over12;
            }
            if (i > 0) continue;
            ++under1;
        }
        if (over31 >= 2 || over12 == 3 || under1 >= 2) {
            return null;
        }
        for (int[] split : possibleYearSplits = new int[][]{{ints[2], ints[0], ints[1]}, {ints[0], ints[1], ints[2]}}) {
            int y = split[0];
            int[] rest = new int[]{split[1], split[2]};
            if (1000 > y || y > 2050) continue;
            Dm dm = this.mapIntsToDm(rest);
            if (dm != null) {
                return new Dmy(dm.day, dm.month, y);
            }
            return null;
        }
        for (int[] split : possibleYearSplits) {
            int[] rest = new int[]{split[1], split[2]};
            Dm dm = this.mapIntsToDm(rest);
            if (dm == null) continue;
            int y = this.twoToFourDigitYear(split[0]);
            return new Dmy(dm.day, dm.month, y);
        }
        return null;
    }

    private Dm mapIntsToDm(int[] ints) {
        int[] copy = Arrays.copyOf(ints, ints.length);
        this.reverse(copy);
        for (int[] ref : new int[][]{ints, copy}) {
            int d = ref[0];
            int m = ref[1];
            if (1 > d || d > 31 || 1 > m || m > 12) continue;
            return new Dm(d, m);
        }
        return null;
    }

    private void reverse(int[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            int temp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = temp;
        }
    }

    private int twoToFourDigitYear(int year) {
        if (year > 99) {
            return year;
        }
        if (year > 50) {
            return year + 1900;
        }
        return year + 2000;
    }

    static {
        DateMatcher.DATE_SPLITS[4] = new int[][]{{1, 2}, {2, 3}};
        DateMatcher.DATE_SPLITS[5] = new int[][]{{1, 3}, {2, 3}};
        DateMatcher.DATE_SPLITS[6] = new int[][]{{1, 2}, {2, 4}, {4, 5}};
        DateMatcher.DATE_SPLITS[7] = new int[][]{{1, 3}, {2, 3}, {4, 5}, {4, 6}};
        DateMatcher.DATE_SPLITS[8] = new int[][]{{2, 4}, {4, 6}};
    }

    private static class Dmy
    extends Dm {
        final int year;

        public Dmy(int day, int month, int year) {
            super(day, month);
            this.year = year;
        }
    }

    private static class Dm {
        final int day;
        final int month;

        public Dm(int day, int month) {
            this.day = day;
            this.month = month;
        }
    }
}

