/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.jetbrains.annotations.NotNull;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.IndicesStatsAction;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.opensearch.index.store.Store;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.replication.ReplicationPlugin;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.action.repository.GetStoreMetadataAction;
import org.opensearch.replication.action.repository.GetStoreMetadataRequest;
import org.opensearch.replication.action.repository.GetStoreMetadataResponse;
import org.opensearch.replication.action.repository.ReleaseLeaderResourcesAction;
import org.opensearch.replication.action.repository.ReleaseLeaderResourcesRequest;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.repository.RemoteClusterMultiChunkTransfer;
import org.opensearch.replication.repository.RemoteClusterRepository;
import org.opensearch.replication.seqno.RemoteClusterRetentionLeaseHelper;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.repositories.RepositoryShardId;
import org.opensearch.repositories.ShardGenerations;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotState;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.NodeDisconnectedException;
import org.opensearch.transport.NodeNotConnectedException;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 \u008f\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u008f\u0001B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J@\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010%H\u0016J:\u0010&\u001a\u00020\u001c2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010%H\u0016J\b\u0010.\u001a\u00020\u001cH\u0014J\b\u0010/\u001a\u00020\u001cH\u0014J\b\u00100\u001a\u00020\u001cH\u0014J\u0010\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020#H\u0016J9\u00103\u001a\u0002H4\"\b\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H4072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020#H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J<\u0010<\u001a\u00020\u001c2\u0014\u0010=\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020?\u0018\u00010>2\b\u0010\u001d\u001a\u0004\u0018\u00010#2\u0012\u0010@\u001a\u000e\u0012\b\u0012\u00060Bj\u0002`C\u0018\u00010AH\u0016J^\u0010D\u001a\u00020\u001c2\b\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010)\u001a\u00020*2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010+\u001a\u0004\u0018\u00010,2\u0014\u0010K\u001a\u0010\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020L\u0018\u00010>2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010%H\u0016J1\u0010M\u001a\u00020L2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0012\u0010Q\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0R\"\u00020#H\u0002\u00a2\u0006\u0002\u0010SJ\b\u0010T\u001a\u00020\u0005H\u0016J\b\u0010U\u001a\u00020*H\u0016J\b\u0010V\u001a\u00020*H\u0016J\u0010\u0010W\u001a\u00020X2\u0006\u0010:\u001a\u00020#H\u0002J\u0016\u0010Y\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020-0%H\u0016J\b\u0010Z\u001a\u00020*H\u0016J\"\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010]\u001a\u00020\u001e2\u0006\u0010^\u001a\u00020_2\u0006\u0010 \u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020H2\u0006\u0010]\u001a\u00020\u001eH\u0016J \u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020-2\u0006\u0010]\u001a\u00020\u001e2\u0006\u0010e\u001a\u00020_H\u0016J\u0010\u0010f\u001a\u00020J2\u0006\u0010]\u001a\u00020\u001eH\u0016J\b\u0010g\u001a\u00020*H\u0016J&\u0010h\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020\u001e2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020_0j2\u0006\u0010k\u001a\u00020HH\u0016J\b\u0010l\u001a\u00020OH\u0016J\b\u0010m\u001a\u00020OH\u0016J5\u0010n\u001a\u0002H4\"\b\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H4072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010oJ0\u0010p\u001a\u00020\u001c2\u0006\u0010q\u001a\u00020#2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020`2\u0006\u0010u\u001a\u00020`2\u0006\u0010v\u001a\u00020#H\u0002J>\u0010w\u001a\u00020\u001c2\u0006\u0010x\u001a\u00020y2\u0006\u0010]\u001a\u00020\u001e2\u0006\u0010^\u001a\u00020_2\u0006\u0010z\u001a\u00020`2\u0006\u0010{\u001a\u00020|2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020}0%H\u0016JG\u0010~\u001a\u00020\u001c2\u0006\u0010x\u001a\u00020y2\u0006\u0010]\u001a\u00020\u001e2\u0006\u0010^\u001a\u00020_2\u0006\u0010z\u001a\u00020`2\u0006\u0010{\u001a\u00020|2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020}0%H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u007fJ\u008a\u0001\u0010\u0080\u0001\u001a\u00020\u001c2\b\u0010x\u001a\u0004\u0018\u00010y2\n\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u00012\b\u0010]\u001a\u0004\u0018\u00010\u001e2\b\u0010^\u001a\u0004\u0018\u00010_2\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u00012\u000b\b\u0001\u0010\u0085\u0001\u001a\u0004\u0018\u00010#2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010\\2\b\u0010+\u001a\u0004\u0018\u00010,2\u0017\u0010\u0087\u0001\u001a\u0012\u0012\u0004\u0012\u00020#\u0012\u0005\u0012\u00030\u0089\u0001\u0018\u00010\u0088\u00012\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010%H\u0016J\t\u0010\u008a\u0001\u001a\u00020#H\u0016J\u0012\u0010\u008b\u0001\u001a\u00020\u001c2\u0007\u0010\u008c\u0001\u001a\u00020LH\u0016J\u001a\u0010\u008d\u0001\u001a\u00020\u001c2\u0006\u00102\u001a\u00020#2\u0007\u0010\u008e\u0001\u001a\u00020sH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0090\u0001"}, d2={"Lorg/opensearch/replication/repository/RemoteClusterRepository;", "Lorg/opensearch/common/lifecycle/AbstractLifecycleComponent;", "Lorg/opensearch/repositories/Repository;", "Lkotlinx/coroutines/CoroutineScope;", "repositoryMetadata", "Lorg/opensearch/cluster/metadata/RepositoryMetadata;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "recoverySettings", "Lorg/opensearch/indices/recovery/RecoverySettings;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "(Lorg/opensearch/cluster/metadata/RepositoryMetadata;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/indices/recovery/RecoverySettings;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;Lorg/opensearch/replication/ReplicationSettings;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "leaderClusterClient", "kotlin.jvm.PlatformType", "getLeaderClusterClient", "()Lorg/opensearch/client/Client;", "leaderClusterClient$delegate", "Lkotlin/Lazy;", "cloneShardSnapshot", "", "source", "Lorg/opensearch/snapshots/SnapshotId;", "target", "shardId", "Lorg/opensearch/repositories/RepositoryShardId;", "shardGeneration", "", "listener", "Lorg/opensearch/core/action/ActionListener;", "deleteSnapshots", "snapshotIds", "", "repositoryStateId", "", "repositoryMetaVersion", "Lorg/opensearch/Version;", "Lorg/opensearch/repositories/RepositoryData;", "doClose", "doStart", "doStop", "endVerification", "verificationToken", "executeActionOnRemote", "T", "Lorg/opensearch/core/action/ActionResponse;", "actionType", "Lorg/opensearch/action/ActionType;", "actionRequest", "Lorg/opensearch/action/ActionRequest;", "followerIndex", "(Lorg/opensearch/action/ActionType;Lorg/opensearch/action/ActionRequest;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeConsistentStateUpdate", "createUpdateTask", "Ljava/util/function/Function;", "Lorg/opensearch/cluster/ClusterStateUpdateTask;", "onFailure", "Ljava/util/function/Consumer;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "finalizeSnapshot", "shardGenerations", "Lorg/opensearch/repositories/ShardGenerations;", "clusterMetadata", "Lorg/opensearch/cluster/metadata/Metadata;", "snapshotInfo", "Lorg/opensearch/snapshots/SnapshotInfo;", "stateTransformer", "Lorg/opensearch/cluster/ClusterState;", "getLeaderClusterState", "includeNodes", "", "includeRoutingTable", "remoteIndices", "", "(ZZ[Ljava/lang/String;)Lorg/opensearch/cluster/ClusterState;", "getMetadata", "getRemoteDownloadThrottleTimeInNanos", "getRemoteUploadThrottleTimeInNanos", "getReplicationMetadata", "Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "getRepositoryData", "getRestoreThrottleTimeInNanos", "getShardSnapshotStatus", "Lorg/opensearch/index/snapshots/IndexShardSnapshotStatus;", "snapshotId", "indexId", "Lorg/opensearch/repositories/IndexId;", "Lorg/opensearch/core/index/shard/ShardId;", "getSnapshotGlobalMetadata", "getSnapshotIndexMetaData", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "repositoryData", "index", "getSnapshotInfo", "getSnapshotThrottleTimeInNanos", "initializeSnapshot", "indices", "", "metadata", "isReadOnly", "isSystemRepository", "leaderClusterGetAction", "(Lorg/opensearch/action/ActionType;Lorg/opensearch/action/ActionRequest;Ljava/lang/String;)Lorg/opensearch/core/action/ActionResponse;", "releaseLeaderResources", "restoreUUID", "leaderShardNode", "Lorg/opensearch/cluster/node/DiscoveryNode;", "leaderShardId", "followerShardId", "followerIndexName", "restoreShard", "store", "Lorg/opensearch/index/store/Store;", "snapshotShardId", "recoveryState", "Lorg/opensearch/indices/recovery/RecoveryState;", "Ljava/lang/Void;", "restoreShardUsingMultiChunkTransfer", "(Lorg/opensearch/index/store/Store;Lorg/opensearch/snapshots/SnapshotId;Lorg/opensearch/repositories/IndexId;Lorg/opensearch/core/index/shard/ShardId;Lorg/opensearch/indices/recovery/RecoveryState;Lorg/opensearch/core/action/ActionListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "snapshotShard", "mapperService", "Lorg/opensearch/index/mapper/MapperService;", "snapshotIndexCommit", "Lorg/apache/lucene/index/IndexCommit;", "shardStateIdentifier", "snapshotStatus", "userMetadata", "", "", "startVerification", "updateState", "state", "verify", "localNode", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nRemoteClusterRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteClusterRepository.kt\norg/opensearch/replication/repository/RemoteClusterRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1549#2:429\n1620#2,3:430\n1855#2,2:433\n1855#2,2:436\n1#3:435\n*S KotlinDebug\n*F\n+ 1 RemoteClusterRepository.kt\norg/opensearch/replication/repository/RemoteClusterRepository\n*L\n205#1:429\n205#1:430,3\n206#1:433,2\n258#1:436,2\n*E\n"})
public final class RemoteClusterRepository
extends AbstractLifecycleComponent
implements Repository,
CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RepositoryMetadata repositoryMetadata;
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final RecoverySettings recoverySettings;
    @NotNull
    private final ReplicationMetadataManager replicationMetadataManager;
    @NotNull
    private final ReplicationSettings replicationSettings;
    private final /* synthetic */ GlobalScope $$delegate_0;
    @NotNull
    private final Lazy leaderClusterClient$delegate;
    private static final Logger log = LogManager.getLogger(RemoteClusterRepository.class);
    @NotNull
    private static final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    public static final long REMOTE_CLUSTER_REPO_REQ_TIMEOUT_IN_MILLI_SEC = 60000L;

    public RemoteClusterRepository(@NotNull RepositoryMetadata repositoryMetadata, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull RecoverySettings recoverySettings, @NotNull ReplicationMetadataManager replicationMetadataManager, @NotNull ReplicationSettings replicationSettings) {
        Intrinsics.checkNotNullParameter((Object)repositoryMetadata, (String)"repositoryMetadata");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)recoverySettings, (String)"recoverySettings");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        this.repositoryMetadata = repositoryMetadata;
        this.client = client;
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
        this.replicationMetadataManager = replicationMetadataManager;
        this.replicationSettings = replicationSettings;
        this.$$delegate_0 = GlobalScope.INSTANCE;
        this.leaderClusterClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Client>(this){
            final /* synthetic */ RemoteClusterRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Client invoke() {
                return RemoteClusterRepository.access$getClient$p(this.this$0).getRemoteClusterClient(org.opensearch.replication.repository.RemoteClusterRepository$Companion.access$leaderClusterName(RemoteClusterRepository.Companion, RemoteClusterRepository.access$getRepositoryMetadata$p(this.this$0)));
            }
        }));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    private final Client getLeaderClusterClient() {
        Lazy lazy = this.leaderClusterClient$delegate;
        return (Client)lazy.getValue();
    }

    public long getRestoreThrottleTimeInNanos() {
        return restoreRateLimitingTimeInNanos.count();
    }

    public long getRemoteUploadThrottleTimeInNanos() {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    public long getRemoteDownloadThrottleTimeInNanos() {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    public void finalizeSnapshot(@org.jetbrains.annotations.Nullable ShardGenerations shardGenerations, long repositoryStateId, @org.jetbrains.annotations.Nullable Metadata clusterMetadata, @org.jetbrains.annotations.Nullable SnapshotInfo snapshotInfo, @org.jetbrains.annotations.Nullable Version repositoryMetaVersion, @org.jetbrains.annotations.Nullable Function<ClusterState, ClusterState> stateTransformer, @org.jetbrains.annotations.Nullable ActionListener<RepositoryData> listener2) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    public void deleteSnapshots(@org.jetbrains.annotations.Nullable Collection<SnapshotId> snapshotIds, long repositoryStateId, @org.jetbrains.annotations.Nullable Version repositoryMetaVersion, @org.jetbrains.annotations.Nullable ActionListener<RepositoryData> listener2) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    public void initializeSnapshot(@NotNull SnapshotId snapshotId, @NotNull List<IndexId> indices, @NotNull Metadata metadata) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @NotNull
    public String startVerification() {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    public void snapshotShard(@org.jetbrains.annotations.Nullable Store store, @org.jetbrains.annotations.Nullable MapperService mapperService, @org.jetbrains.annotations.Nullable SnapshotId snapshotId, @org.jetbrains.annotations.Nullable IndexId indexId, @org.jetbrains.annotations.Nullable IndexCommit snapshotIndexCommit, @Nullable @org.jetbrains.annotations.Nullable String shardStateIdentifier, @org.jetbrains.annotations.Nullable IndexShardSnapshotStatus snapshotStatus, @org.jetbrains.annotations.Nullable Version repositoryMetaVersion, @org.jetbrains.annotations.Nullable Map<String, Object> userMetadata, @org.jetbrains.annotations.Nullable ActionListener<String> listener2) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @NotNull
    public RepositoryMetadata getMetadata() {
        return this.repositoryMetadata;
    }

    public void verify(@NotNull String verificationToken, @NotNull DiscoveryNode localNode) {
        Intrinsics.checkNotNullParameter((Object)verificationToken, (String)"verificationToken");
        Intrinsics.checkNotNullParameter((Object)localNode, (String)"localNode");
    }

    public void cloneShardSnapshot(@org.jetbrains.annotations.Nullable SnapshotId source, @org.jetbrains.annotations.Nullable SnapshotId target, @org.jetbrains.annotations.Nullable RepositoryShardId shardId, @org.jetbrains.annotations.Nullable String shardGeneration, @org.jetbrains.annotations.Nullable ActionListener<String> listener2) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    public void endVerification(@NotNull String verificationToken) {
        Intrinsics.checkNotNullParameter((Object)verificationToken, (String)"verificationToken");
    }

    public long getSnapshotThrottleTimeInNanos() {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @org.jetbrains.annotations.Nullable
    public IndexShardSnapshotStatus getShardSnapshotStatus(@NotNull SnapshotId snapshotId, @NotNull IndexId indexId, @NotNull ShardId shardId) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        String[] stringArray = new String[]{indexId.getName()};
        IndicesStatsRequest indicesStatsRequest = (IndicesStatsRequest)new IndicesStatsRequest().all().indices(stringArray);
        IndicesStatsAction indicesStatsAction = IndicesStatsAction.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)indicesStatsAction, (String)"INSTANCE");
        ActionType actionType = (ActionType)indicesStatsAction;
        Intrinsics.checkNotNullExpressionValue((Object)indicesStatsRequest, (String)"indicesStatsRequest");
        ActionRequest actionRequest = (ActionRequest)indicesStatsRequest;
        String string = shardId.getIndexName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shardId.indexName");
        IndicesStatsResponse indicesStatsResponse = (IndicesStatsResponse)this.leaderClusterGetAction(actionType, actionRequest, string);
        int n = indicesStatsResponse.getShards().length;
        for (int i = 0; i < n; ++i) {
            if (indicesStatsResponse.getShards()[i].getShardRouting().shardId().getId() != shardId.getId()) continue;
            CommonStats commonStats = indicesStatsResponse.getShards()[i].getStats();
            Long l = commonStats != null && (commonStats = commonStats.store) != null ? Long.valueOf(commonStats.getSizeInBytes()) : null;
            Intrinsics.checkNotNull(l);
            long sizeInBytes = l;
            return IndexShardSnapshotStatus.newDone((long)0L, (long)3L, (int)1, (int)1, (long)sizeInBytes, (long)sizeInBytes, (String)"");
        }
        return null;
    }

    public void updateState(@NotNull ClusterState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public void executeConsistentStateUpdate(@org.jetbrains.annotations.Nullable Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, @org.jetbrains.annotations.Nullable String source, @org.jetbrains.annotations.Nullable Consumer<Exception> onFailure2) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    /*
     * WARNING - void declaration
     */
    public void getRepositoryData(@NotNull ActionListener<RepositoryData> listener2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ClusterState clusterState = this.getLeaderClusterState(false, false, new String[0]);
        ShardGenerations.Builder shardGenerations = ShardGenerations.builder();
        Iterable iterable = clusterState.getMetadata().getIndices().values();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexMetadata indexMetadata = (IndexMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexMetadata indexMetadata = (IndexMetadata)element$iv;
            boolean bl = false;
            IndexId indexId = new IndexId(indexMetadata.getIndex().getName(), indexMetadata.getIndexUUID());
            int n = indexMetadata.getNumberOfShards();
            for (int i = 0; i < n; ++i) {
                shardGenerations.put(indexId, i, "dummy");
            }
        }
        SnapshotId snapshotId = new SnapshotId("replication-remote-snapshot", RemoteClusterRepository.Companion.asUUID("replication-remote-snapshot"));
        RepositoryData repositoryData = RepositoryData.EMPTY.addSnapshot(snapshotId, SnapshotState.SUCCESS, Version.CURRENT, shardGenerations.build(), null, null);
        listener2.onResponse((Object)repositoryData);
    }

    @NotNull
    public SnapshotInfo getSnapshotInfo(@NotNull SnapshotId snapshotId) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        ClusterState leaderClusterState = this.getLeaderClusterState(false, false, new String[0]);
        boolean bl = "replication-remote-snapshot".equals(snapshotId.getName());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "SnapshotName differs";
            throw new AssertionError((Object)string);
        }
        List indices = CollectionsKt.toList((Iterable)leaderClusterState.metadata().indices().keySet());
        return new SnapshotInfo(snapshotId, indices, CollectionsKt.emptyList(), SnapshotState.SUCCESS, Version.CURRENT);
    }

    @NotNull
    public Metadata getSnapshotGlobalMetadata(@NotNull SnapshotId snapshotId) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public IndexMetadata getSnapshotIndexMetaData(@NotNull RepositoryData repositoryData, @NotNull SnapshotId snapshotId, @NotNull IndexId index) {
        Intrinsics.checkNotNullParameter((Object)repositoryData, (String)"repositoryData");
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        boolean bl = "replication-remote-snapshot".equals(snapshotId.getName());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RemoteClusterRepository$getSnapshotIndexMetaData$22 = false;
            String $i$a$-assert-RemoteClusterRepository$getSnapshotIndexMetaData$22 = "SnapshotName differs";
            throw new AssertionError((Object)$i$a$-assert-RemoteClusterRepository$getSnapshotIndexMetaData$22);
        }
        String[] $i$a$-assert-RemoteClusterRepository$getSnapshotIndexMetaData$22 = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)index.getName(), (String)"index.name");
        ClusterState leaderClusterState = this.getLeaderClusterState(false, false, $i$a$-assert-RemoteClusterRepository$getSnapshotIndexMetaData$22);
        IndexMetadata indexMetadata = leaderClusterState.getMetadata().index(index.getName());
        Settings.Builder builder = Settings.builder().put(indexMetadata.getSettings());
        String replicatedIndex = RemoteClusterRepository.Companion.leaderClusterName(this.repositoryMetadata) + ':' + index.getName();
        builder.put(ReplicationPlugin.Companion.getREPLICATED_INDEX_SETTING().getKey(), replicatedIndex);
        builder.remove(ReplicationPlugin.Companion.getREPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING().getKey());
        builder.remove("index.remote_store.enabled");
        builder.remove("index.remote_store.segment.repository");
        builder.remove("index.remote_store.translog.repository");
        IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder((IndexMetadata)indexMetadata).settings(builder);
        Iterable $this$forEach$iv = indexMetadata.getAliases().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AliasMetadata it = (AliasMetadata)element$iv;
            boolean bl2 = false;
            indexMdBuilder.putAlias(it);
        }
        IndexMetadata indexMetadata2 = indexMdBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)indexMetadata2, (String)"indexMdBuilder.build()");
        return indexMetadata2;
    }

    public void restoreShard(@NotNull Store store, @NotNull SnapshotId snapshotId, @NotNull IndexId indexId, @NotNull ShardId snapshotShardId, @NotNull RecoveryState recoveryState, @NotNull ActionListener<Void> listener2) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        Intrinsics.checkNotNullParameter((Object)snapshotShardId, (String)"snapshotShardId");
        Intrinsics.checkNotNullParameter((Object)recoveryState, (String)"recoveryState");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        CoroutineScope coroutineScope = this;
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
        ThreadPool threadPool = this.getLeaderClusterClient().threadPool();
        Intrinsics.checkNotNullExpressionValue((Object)threadPool, (String)"leaderClusterClient.threadPool()");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineDispatcher.plus(CoroutinesKt.coroutineContext(threadPool)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(store, this, snapshotId, indexId, snapshotShardId, recoveryState, listener2, null){
            int label;
            final /* synthetic */ Store $store;
            final /* synthetic */ RemoteClusterRepository this$0;
            final /* synthetic */ SnapshotId $snapshotId;
            final /* synthetic */ IndexId $indexId;
            final /* synthetic */ ShardId $snapshotShardId;
            final /* synthetic */ RecoveryState $recoveryState;
            final /* synthetic */ ActionListener<Void> $listener;
            {
                this.$store = $store;
                this.this$0 = $receiver;
                this.$snapshotId = $snapshotId;
                this.$indexId = $indexId;
                this.$snapshotShardId = $snapshotShardId;
                this.$recoveryState = $recoveryState;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @org.jetbrains.annotations.Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$store.incRef();
                        Function7 function7 = (Function7)new Function7<Store, SnapshotId, IndexId, ShardId, RecoveryState, ActionListener<Void>, Continuation<? super Unit>, Object>((Object)((Object)this.this$0)){

                            @org.jetbrains.annotations.Nullable
                            public final Object invoke(@NotNull Store p0, @NotNull SnapshotId p1, @NotNull IndexId p2, @NotNull ShardId p3, @NotNull RecoveryState p4, @NotNull ActionListener<Void> p5, @NotNull Continuation<? super Unit> $completion) {
                                return ((RemoteClusterRepository)((Object)this.receiver)).restoreShardUsingMultiChunkTransfer(p0, p1, p2, p3, p4, p5, $completion);
                            }
                        };
                        Logger logger = RemoteClusterRepository.access$getLog$cp();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
                        this.label = 1;
                        Object object3 = ExtensionsKt.restoreShardWithRetries$default(this.this$0, this.$store, this.$snapshotId, this.$indexId, this.$snapshotShardId, this.$recoveryState, this.$listener, function7, 0, 0L, 0L, 0.0, logger, null, (Continuation)this, 6016, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@org.jetbrains.annotations.Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @org.jetbrains.annotations.Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @org.jetbrains.annotations.Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    @org.jetbrains.annotations.Nullable
    public final Object restoreShardUsingMultiChunkTransfer(@NotNull Store var1_1, @NotNull SnapshotId var2_2, @NotNull IndexId var3_3, @NotNull ShardId var4_4, @NotNull RecoveryState var5_5, @NotNull ActionListener<Void> var6_6, @NotNull Continuation<? super Unit> var7_7) {
        if (!(var7_7 instanceof restoreShardUsingMultiChunkTransfer.1)) ** GOTO lbl-1000
        var22_8 = var7_7;
        if ((var22_8.label & -2147483648) != 0) {
            var22_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var7_7){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.restoreShardUsingMultiChunkTransfer(null, null, null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                restoreUUID = new Ref.ObjectRef();
                leaderShardNode = new Ref.ObjectRef();
                leaderShardId = new Ref.ObjectRef();
                followerIndexName = store.shardId().getIndexName();
                followerShardId = store.shardId();
                var15_16 = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)indexId.getName(), (String)"indexId.name");
                leaderClusterState = this.getLeaderClusterState(true, true, var15_16);
                leaderShardRouting = leaderClusterState.getRoutingTable().shardRoutingTable(snapshotShardId.getIndexName(), snapshotShardId.getId()).primaryShard();
                leaderShardNode.element = leaderClusterState.getNodes().get(leaderShardRouting.currentNodeId());
                leaderShardId.element = new ShardId(snapshotShardId.getIndexName(), leaderClusterState.getMetadata().index(indexId.getName()).getIndexUUID(), snapshotShardId.getId());
                restoreUUID.element = UUIDs.randomBase64UUID();
                v0 = (String)restoreUUID.element;
                v1 = (DiscoveryNode)leaderShardNode.element;
                v2 = (ShardId)leaderShardId.element;
                v3 = this.clusterService.getClusterName().value();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"clusterService.clusterName.value()");
                v4 = this.clusterService.state().getMetadata().clusterUUID();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"clusterService.state().metadata.clusterUUID()");
                v5 = RemoteClusterRetentionLeaseHelper.Companion.getFollowerClusterNameWithUUID(v3, v4);
                Intrinsics.checkNotNullExpressionValue((Object)followerShardId, (String)"followerShardId");
                getStoreMetadataRequest = new GetStoreMetadataRequest(v0, v1, v2, v5, followerShardId);
                v6 = GetStoreMetadataAction.Companion.getINSTANCE();
                v7 = (ActionRequest)getStoreMetadataRequest;
                Intrinsics.checkNotNullExpressionValue((Object)followerIndexName, (String)"followerIndexName");
                $continuation.L$0 = this;
                $continuation.L$1 = store;
                $continuation.L$2 = snapshotId;
                $continuation.L$3 = indexId;
                $continuation.L$4 = snapshotShardId;
                $continuation.L$5 = recoveryState;
                $continuation.L$6 = listener;
                $continuation.L$7 = restoreUUID;
                $continuation.L$8 = leaderShardNode;
                $continuation.L$9 = leaderShardId;
                $continuation.L$10 = followerIndexName;
                $continuation.L$11 = followerShardId;
                $continuation.label = 1;
                v8 = this.executeActionOnRemote((ActionType<T>)v6, v7, followerIndexName, (Continuation<? super T>)$continuation);
                if (v8 == var23_10) {
                    return var23_10;
                }
                ** GOTO lbl69
            }
            case 1: {
                followerShardId = (ShardId)$continuation.L$11;
                followerIndexName = (String)$continuation.L$10;
                leaderShardId = (Ref.ObjectRef)$continuation.L$9;
                leaderShardNode = (Ref.ObjectRef)$continuation.L$8;
                restoreUUID = (Ref.ObjectRef)$continuation.L$7;
                listener = (ActionListener)$continuation.L$6;
                recoveryState = (RecoveryState)$continuation.L$5;
                snapshotShardId = (ShardId)$continuation.L$4;
                indexId = (IndexId)$continuation.L$3;
                snapshotId = (SnapshotId)$continuation.L$2;
                store = (Store)$continuation.L$1;
                this = (RemoteClusterRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl69:
                // 2 sources

                metadataResponse = (GetStoreMetadataResponse)v8;
                metadataSnapshot = metadataResponse.getMetadataSnapshot();
                Intrinsics.checkNotNullExpressionValue((Object)followerIndexName, (String)"followerIndexName");
                replMetadata = this.getReplicationMetadata(followerIndexName);
                fileMetadata = new ArrayList<V>(metadataSnapshot.asMap().values());
                v9 = RemoteClusterRepository.log;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"log");
                v10 = this.clusterService.getClusterName().value();
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"clusterService.clusterName.value()");
                v11 = this.client.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"client.threadPool().threadContext");
                v12 = this.replicationSettings.getConcurrentFileChunks();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"replicationSettings.concurrentFileChunks");
                v13 = ((Number)v12).intValue();
                v14 = (String)restoreUUID.element;
                v15 = (DiscoveryNode)leaderShardNode.element;
                v16 = (ShardId)leaderShardId.element;
                v17 = fileMetadata;
                v18 = this.getLeaderClusterClient();
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"leaderClusterClient");
                v19 = this.replicationSettings.getChunkSize();
                Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"replicationSettings.chunkSize");
                multiChunkTransfer = new RemoteClusterMultiChunkTransfer(v9, v10, v11, store, v13, v14, replMetadata, v15, v16, v17, v18, recoveryState, v19, (ActionListener<Void>)((ActionListener)new ActionListener<Void>(store, this, (Ref.ObjectRef<String>)restoreUUID, (Ref.ObjectRef<DiscoveryNode>)leaderShardNode, (Ref.ObjectRef<ShardId>)leaderShardId, followerShardId, followerIndexName, (ActionListener<Void>)listener, snapshotId, indexId, snapshotShardId, recoveryState){
                    final /* synthetic */ Store $store;
                    final /* synthetic */ RemoteClusterRepository this$0;
                    final /* synthetic */ Ref.ObjectRef<String> $restoreUUID;
                    final /* synthetic */ Ref.ObjectRef<DiscoveryNode> $leaderShardNode;
                    final /* synthetic */ Ref.ObjectRef<ShardId> $leaderShardId;
                    final /* synthetic */ ShardId $followerShardId;
                    final /* synthetic */ String $followerIndexName;
                    final /* synthetic */ ActionListener<Void> $listener;
                    final /* synthetic */ SnapshotId $snapshotId;
                    final /* synthetic */ IndexId $indexId;
                    final /* synthetic */ ShardId $snapshotShardId;
                    final /* synthetic */ RecoveryState $recoveryState;
                    {
                        this.$store = $store;
                        this.this$0 = $receiver;
                        this.$restoreUUID = $restoreUUID;
                        this.$leaderShardNode = $leaderShardNode;
                        this.$leaderShardId = $leaderShardId;
                        this.$followerShardId = $followerShardId;
                        this.$followerIndexName = $followerIndexName;
                        this.$listener = $listener;
                        this.$snapshotId = $snapshotId;
                        this.$indexId = $indexId;
                        this.$snapshotShardId = $snapshotShardId;
                        this.$recoveryState = $recoveryState;
                    }

                    public void onFailure(@org.jetbrains.annotations.Nullable Exception e) {
                        Exception exception = e;
                        RemoteClusterRepository.access$getLog$cp().error("Restore of " + this.$store.shardId() + " failed due to " + (exception != null ? ExtensionsKt.stackTraceToString(exception) : null));
                        if (e instanceof NodeDisconnectedException || e instanceof NodeNotConnectedException || e instanceof ConnectTransportException) {
                            RemoteClusterRepository.access$getLog$cp().info("Retrying restore shard for " + this.$store.shardId());
                            Thread.sleep(1000L);
                            CoroutineScope coroutineScope = this.this$0;
                            CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
                            ThreadPool threadPool = RemoteClusterRepository.access$getLeaderClusterClient(this.this$0).threadPool();
                            Intrinsics.checkNotNullExpressionValue((Object)threadPool, (String)"leaderClusterClient.threadPool()");
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineDispatcher.plus(CoroutinesKt.coroutineContext(threadPool)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$store, this.$snapshotId, this.$indexId, this.$snapshotShardId, this.$recoveryState, this.$listener, null){
                                int label;
                                final /* synthetic */ RemoteClusterRepository this$0;
                                final /* synthetic */ Store $store;
                                final /* synthetic */ SnapshotId $snapshotId;
                                final /* synthetic */ IndexId $indexId;
                                final /* synthetic */ ShardId $snapshotShardId;
                                final /* synthetic */ RecoveryState $recoveryState;
                                final /* synthetic */ ActionListener<Void> $listener;
                                {
                                    this.this$0 = $receiver;
                                    this.$store = $store;
                                    this.$snapshotId = $snapshotId;
                                    this.$indexId = $indexId;
                                    this.$snapshotShardId = $snapshotShardId;
                                    this.$recoveryState = $recoveryState;
                                    this.$listener = $listener;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @org.jetbrains.annotations.Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Function7 function7 = (Function7)new Function7<Store, SnapshotId, IndexId, ShardId, RecoveryState, ActionListener<Void>, Continuation<? super Unit>, Object>((Object)((Object)this.this$0)){

                                                @org.jetbrains.annotations.Nullable
                                                public final Object invoke(@NotNull Store p0, @NotNull SnapshotId p1, @NotNull IndexId p2, @NotNull ShardId p3, @NotNull RecoveryState p4, @NotNull ActionListener<Void> p5, @NotNull Continuation<? super Unit> $completion) {
                                                    return ((RemoteClusterRepository)((Object)this.receiver)).restoreShardUsingMultiChunkTransfer(p0, p1, p2, p3, p4, p5, $completion);
                                                }
                                            };
                                            Logger logger = RemoteClusterRepository.access$getLog$cp();
                                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
                                            this.label = 1;
                                            Object object3 = ExtensionsKt.restoreShardWithRetries$default(this.this$0, this.$store, this.$snapshotId, this.$indexId, this.$snapshotShardId, this.$recoveryState, this.$listener, function7, 0, 0L, 0L, 0.0, logger, null, (Continuation)this, 6016, null);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@org.jetbrains.annotations.Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @org.jetbrains.annotations.Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @org.jetbrains.annotations.Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                        } else {
                            RemoteClusterRepository.access$getLog$cp().error("Not retrying restore shard for " + this.$store.shardId());
                            this.$store.decRef();
                            String string = (String)this.$restoreUUID.element;
                            DiscoveryNode discoveryNode = (DiscoveryNode)this.$leaderShardNode.element;
                            ShardId shardId = (ShardId)this.$leaderShardId.element;
                            ShardId shardId2 = this.$followerShardId;
                            Intrinsics.checkNotNullExpressionValue((Object)shardId2, (String)"followerShardId");
                            String string2 = this.$followerIndexName;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"followerIndexName");
                            RemoteClusterRepository.access$releaseLeaderResources(this.this$0, string, discoveryNode, shardId, shardId2, string2);
                            this.$listener.onFailure(e);
                        }
                    }

                    public void onResponse(@org.jetbrains.annotations.Nullable Void response2) {
                        RemoteClusterRepository.access$getLog$cp().info("Restore successful for " + this.$store.shardId());
                        this.$store.decRef();
                        String string = (String)this.$restoreUUID.element;
                        DiscoveryNode discoveryNode = (DiscoveryNode)this.$leaderShardNode.element;
                        ShardId shardId = (ShardId)this.$leaderShardId.element;
                        ShardId shardId2 = this.$followerShardId;
                        Intrinsics.checkNotNullExpressionValue((Object)shardId2, (String)"followerShardId");
                        String string2 = this.$followerIndexName;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"followerIndexName");
                        RemoteClusterRepository.access$releaseLeaderResources(this.this$0, string, discoveryNode, shardId, shardId2, string2);
                        this.$listener.onResponse(null);
                    }
                }));
                if (fileMetadata.isEmpty()) {
                    RemoteClusterRepository.log.info("Initializing with empty store for shard:" + snapshotShardId.getId());
                    store.createEmpty(store.indexSettings().getIndexVersionCreated().luceneVersion);
                    store.decRef();
                    v20 = (String)restoreUUID.element;
                    v21 = (DiscoveryNode)leaderShardNode.element;
                    v22 = (ShardId)leaderShardId.element;
                    Intrinsics.checkNotNullExpressionValue((Object)followerShardId, (String)"followerShardId");
                    this.releaseLeaderResources(v20, v21, v22, followerShardId, followerIndexName);
                    listener.onResponse(null);
                } else {
                    multiChunkTransfer.start();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void releaseLeaderResources(String restoreUUID, DiscoveryNode leaderShardNode, ShardId leaderShardId, ShardId followerShardId, String followerIndexName) {
        try {
            String string = this.clusterService.getClusterName().value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clusterService.clusterName.value()");
            ReleaseLeaderResourcesRequest releaseResourcesReq = new ReleaseLeaderResourcesRequest(restoreUUID, leaderShardNode, leaderShardId, string, followerShardId);
            if (((AcknowledgedResponse)this.leaderClusterGetAction(ReleaseLeaderResourcesAction.Companion.getINSTANCE(), (ActionRequest)releaseResourcesReq, followerIndexName)).isAcknowledged()) {
                log.info("Successfully released resources at the leader cluster for " + leaderShardId + " at " + leaderShardNode);
            }
        }
        catch (Exception e) {
            log.error("Releasing leader resource failed due to " + ExtensionsKt.stackTraceToString(e));
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSystemRepository() {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    private final ClusterState getLeaderClusterState(boolean includeNodes, boolean includeRoutingTable, String ... remoteIndices) {
        ClusterStateRequest clusterStateRequest = (ClusterStateRequest)this.getLeaderClusterClient().admin().cluster().prepareState().clear().setIndices(Arrays.copyOf(remoteIndices, remoteIndices.length)).setMetadata(true).setNodes(includeNodes).setRoutingTable(includeRoutingTable).setIndicesOptions(IndicesOptions.strictSingleIndexNoExpandForbidClosed()).request();
        ClusterState remoteState2 = ((ClusterStateResponse)this.getLeaderClusterClient().admin().cluster().state(clusterStateRequest).actionGet(60000L)).getState();
        log.trace("Successfully fetched the cluster state from remote repository " + remoteState2);
        Intrinsics.checkNotNullExpressionValue((Object)remoteState2, (String)"remoteState");
        return remoteState2;
    }

    private final ReplicationMetadata getReplicationMetadata(String followerIndex) {
        return ReplicationMetadataManager.getIndexReplicationMetadata$default(this.replicationMetadataManager, followerIndex, RemoteClusterRepository.Companion.leaderClusterName(this.repositoryMetadata), true, 0L, 8, null);
    }

    private final <T extends ActionResponse> T leaderClusterGetAction(ActionType<T> actionType, ActionRequest actionRequest, String followerIndex) {
        ReplicationMetadata replMetadata = this.getReplicationMetadata(followerIndex);
        Client client = this.getLeaderClusterClient();
        Intrinsics.checkNotNullExpressionValue((Object)client, (String)"leaderClusterClient");
        return ExtensionsKt.execute(client, replMetadata, actionType, actionRequest, 60000L);
    }

    private final <T extends ActionResponse> Object executeActionOnRemote(ActionType<T> actionType, ActionRequest actionRequest, String followerIndex, Continuation<? super T> $completion) {
        ReplicationMetadata replMetadata = this.getReplicationMetadata(followerIndex);
        Client client = this.getLeaderClusterClient();
        Intrinsics.checkNotNullExpressionValue((Object)client, (String)"leaderClusterClient");
        return CoroutinesKt.suspendExecute$default((OpenSearchClient)client, replMetadata, actionType, actionRequest, false, $completion, 8, null);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ Client access$getLeaderClusterClient(RemoteClusterRepository $this) {
        return $this.getLeaderClusterClient();
    }

    public static final /* synthetic */ void access$releaseLeaderResources(RemoteClusterRepository $this, String restoreUUID, DiscoveryNode leaderShardNode, ShardId leaderShardId, ShardId followerShardId, String followerIndexName) {
        $this.releaseLeaderResources(restoreUUID, leaderShardNode, leaderShardId, followerShardId, followerIndexName);
    }

    public static final /* synthetic */ Object access$executeActionOnRemote(RemoteClusterRepository $this, ActionType actionType, ActionRequest actionRequest, String followerIndex, Continuation $completion) {
        return $this.executeActionOnRemote(actionType, actionRequest, followerIndex, $completion);
    }

    public static final /* synthetic */ Client access$getClient$p(RemoteClusterRepository $this) {
        return $this.client;
    }

    public static final /* synthetic */ RepositoryMetadata access$getRepositoryMetadata$p(RemoteClusterRepository $this) {
        return $this.repositoryMetadata;
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\f\u0010\u000f\u001a\u00020\u000b*\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\u000b*\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/replication/repository/RemoteClusterRepository$Companion;", "", "()V", "REMOTE_CLUSTER_REPO_REQ_TIMEOUT_IN_MILLI_SEC", "", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "restoreRateLimitingTimeInNanos", "Lorg/opensearch/common/metrics/CounterMetric;", "clusterForRepo", "", "remoteRepoName", "repoForCluster", "leaderClusterName", "asUUID", "Lorg/opensearch/cluster/metadata/RepositoryMetadata;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        private final String asUUID(String $this$asUUID) {
            String string = $this$asUUID;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String string2 = UUID.nameUUIDFromBytes(byArray).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nameUUIDFromBytes(toByteArray()).toString()");
            return string2;
        }

        private final String leaderClusterName(RepositoryMetadata $this$leaderClusterName) {
            String string = $this$leaderClusterName.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name()");
            String[] stringArray = new String[]{"replication-remote-repo-"};
            return (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        }

        @NotNull
        public final String clusterForRepo(@NotNull String remoteRepoName) {
            Intrinsics.checkNotNullParameter((Object)remoteRepoName, (String)"remoteRepoName");
            String[] stringArray = new String[]{"replication-remote-repo-"};
            return (String)StringsKt.split$default((CharSequence)remoteRepoName, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        }

        @NotNull
        public final String repoForCluster(@NotNull String leaderClusterName) {
            Intrinsics.checkNotNullParameter((Object)leaderClusterName, (String)"leaderClusterName");
            return "replication-remote-repo-" + leaderClusterName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

