/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.update;

import java.util.Map;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.WriteRequestBuilder;
import org.opensearch.action.support.single.instance.InstanceShardOperationRequestBuilder;
import org.opensearch.action.update.UpdateAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.Nullable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.VersionType;
import org.opensearch.script.Script;

public class UpdateRequestBuilder
extends InstanceShardOperationRequestBuilder<UpdateRequest, UpdateResponse, UpdateRequestBuilder>
implements WriteRequestBuilder<UpdateRequestBuilder> {
    public UpdateRequestBuilder(OpenSearchClient client, UpdateAction action) {
        super(client, action, new UpdateRequest());
    }

    public UpdateRequestBuilder(OpenSearchClient client, UpdateAction action, String index, String id) {
        super(client, action, new UpdateRequest(index, id));
    }

    public UpdateRequestBuilder setId(String id) {
        ((UpdateRequest)this.request).id(id);
        return this;
    }

    public UpdateRequestBuilder setRouting(String routing) {
        ((UpdateRequest)this.request).routing(routing);
        return this;
    }

    public UpdateRequestBuilder setScript(Script script) {
        ((UpdateRequest)this.request).script(script);
        return this;
    }

    public UpdateRequestBuilder setFetchSource(@Nullable String include, @Nullable String exclude) {
        ((UpdateRequest)this.request).fetchSource(include, exclude);
        return this;
    }

    public UpdateRequestBuilder setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        ((UpdateRequest)this.request).fetchSource(includes, excludes);
        return this;
    }

    public UpdateRequestBuilder setFetchSource(boolean fetchSource) {
        ((UpdateRequest)this.request).fetchSource(fetchSource);
        return this;
    }

    public UpdateRequestBuilder setRetryOnConflict(int retryOnConflict) {
        ((UpdateRequest)this.request).retryOnConflict(retryOnConflict);
        return this;
    }

    public UpdateRequestBuilder setVersion(long version) {
        ((UpdateRequest)this.request).version(version);
        return this;
    }

    public UpdateRequestBuilder setVersionType(VersionType versionType) {
        ((UpdateRequest)this.request).versionType(versionType);
        return this;
    }

    public UpdateRequestBuilder setIfSeqNo(long seqNo) {
        ((UpdateRequest)this.request).setIfSeqNo(seqNo);
        return this;
    }

    public UpdateRequestBuilder setIfPrimaryTerm(long term) {
        ((UpdateRequest)this.request).setIfPrimaryTerm(term);
        return this;
    }

    public UpdateRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((UpdateRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public UpdateRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public UpdateRequestBuilder setDoc(IndexRequest indexRequest) {
        ((UpdateRequest)this.request).doc(indexRequest);
        return this;
    }

    public UpdateRequestBuilder setDoc(XContentBuilder source) {
        ((UpdateRequest)this.request).doc(source);
        return this;
    }

    public UpdateRequestBuilder setDoc(Map<String, Object> source) {
        ((UpdateRequest)this.request).doc(source);
        return this;
    }

    public UpdateRequestBuilder setDoc(Map<String, Object> source, MediaType contentType) {
        ((UpdateRequest)this.request).doc(source, contentType);
        return this;
    }

    public UpdateRequestBuilder setDoc(String source, MediaType mediaType) {
        ((UpdateRequest)this.request).doc(source, mediaType);
        return this;
    }

    public UpdateRequestBuilder setDoc(byte[] source, MediaType mediaType) {
        ((UpdateRequest)this.request).doc(source, mediaType);
        return this;
    }

    public UpdateRequestBuilder setDoc(byte[] source, int offset, int length, MediaType mediaType) {
        ((UpdateRequest)this.request).doc(source, offset, length, mediaType);
        return this;
    }

    public UpdateRequestBuilder setDoc(Object ... source) {
        ((UpdateRequest)this.request).doc(source);
        return this;
    }

    public UpdateRequestBuilder setDoc(MediaType mediaType, Object ... source) {
        ((UpdateRequest)this.request).doc(mediaType, source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(IndexRequest indexRequest) {
        ((UpdateRequest)this.request).upsert(indexRequest);
        return this;
    }

    public UpdateRequestBuilder setUpsert(XContentBuilder source) {
        ((UpdateRequest)this.request).upsert(source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(Map<String, Object> source) {
        ((UpdateRequest)this.request).upsert(source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(Map<String, Object> source, MediaType mediaType) {
        ((UpdateRequest)this.request).upsert(source, mediaType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(String source, MediaType mediaType) {
        ((UpdateRequest)this.request).upsert(source, mediaType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(byte[] source, MediaType mediaType) {
        ((UpdateRequest)this.request).upsert(source, mediaType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(byte[] source, int offset, int length, MediaType mediaType) {
        ((UpdateRequest)this.request).upsert(source, offset, length, mediaType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(Object ... source) {
        ((UpdateRequest)this.request).upsert(source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(MediaType mediaType, Object ... source) {
        ((UpdateRequest)this.request).upsert(mediaType, source);
        return this;
    }

    public UpdateRequestBuilder setDocAsUpsert(boolean shouldUpsertDoc) {
        ((UpdateRequest)this.request).docAsUpsert(shouldUpsertDoc);
        return this;
    }

    public UpdateRequestBuilder setDetectNoop(boolean detectNoop) {
        ((UpdateRequest)this.request).detectNoop(detectNoop);
        return this;
    }

    public UpdateRequestBuilder setScriptedUpsert(boolean scriptedUpsert) {
        ((UpdateRequest)this.request).scriptedUpsert(scriptedUpsert);
        return this;
    }
}

