/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenizerFactory;

public class StandardTokenizerFactory
extends AbstractTokenizerFactory {
    private final int maxTokenLength;

    public StandardTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        this.maxTokenLength = settings.getAsInt("max_token_length", 255);
    }

    @Override
    public Tokenizer create() {
        StandardTokenizer tokenizer = new StandardTokenizer();
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

