/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.feature;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tribuo.Feature;
import org.tribuo.data.columnar.ColumnarFeature;
import org.tribuo.data.columnar.FeatureProcessor;

public class UniqueProcessor
implements FeatureProcessor {
    @Config(mandatory=true, description="The operation to perform.")
    private UniqueType reductionType;

    private UniqueProcessor() {
    }

    public UniqueProcessor(UniqueType reductionType) {
        this.reductionType = reductionType;
    }

    @Override
    public List<ColumnarFeature> process(List<ColumnarFeature> features) {
        if (features.isEmpty()) {
            return features;
        }
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (ColumnarFeature f : features) {
            map.computeIfAbsent(f.getName(), s -> new ArrayList()).add(f);
        }
        ArrayList<ColumnarFeature> returnVal = new ArrayList<ColumnarFeature>();
        for (Map.Entry e : map.entrySet()) {
            returnVal.add(UniqueProcessor.uniqueList(this.reductionType, (List)e.getValue()));
        }
        return returnVal;
    }

    private static ColumnarFeature uniqueList(UniqueType type, List<ColumnarFeature> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("List must contain at least one feature");
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        switch (type) {
            case FIRST: {
                return list.get(0);
            }
            case LAST: {
                return list.get(list.size() - 1);
            }
            case MAX: {
                return list.stream().max(Comparator.comparingDouble(Feature::getValue)).get();
            }
            case MIN: {
                return list.stream().min(Comparator.comparingDouble(Feature::getValue)).get();
            }
            case SUM: {
                double value = 0.0;
                for (ColumnarFeature f : list) {
                    value += f.getValue();
                }
                ColumnarFeature first = list.get(0);
                if (first.getFieldName().equals("CONJ")) {
                    return new ColumnarFeature(first.getFirstFieldName(), first.getSecondFieldName(), first.getColumnEntry(), value);
                }
                return new ColumnarFeature(first.getFieldName(), first.getColumnEntry(), value);
            }
        }
        throw new IllegalStateException("Unknown enum type " + (Object)((Object)type));
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FeatureProcessor");
    }

    public static enum UniqueType {
        FIRST,
        LAST,
        MAX,
        MIN,
        SUM;

    }
}

