/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.alerting.model.Finding;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.correlation.index.query.CorrelationQueryBuilder;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.transport.TransportCorrelateFindingAction;

public class VectorEmbeddingsEngine {
    private final Client client;
    private final TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction;
    private volatile TimeValue indexTimeout;
    private volatile long corrTimeWindow;
    private static final Logger log = LogManager.getLogger(VectorEmbeddingsEngine.class);

    public VectorEmbeddingsEngine(Client client, TimeValue indexTimeout, long corrTimeWindow, TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction) {
        this.client = client;
        this.indexTimeout = indexTimeout;
        this.corrTimeWindow = corrTimeWindow;
        this.correlateFindingAction = correlateFindingAction;
    }

    public void insertCorrelatedFindings(final String detectorType, final Finding finding, final String logType, final List<String> correlatedFindings, final float timestampFeature, final List<String> correlationRules, final Map<String, CustomLogType> logTypes) {
        Map<String, Object> tags = logTypes.get(detectorType).getTags();
        final String correlationId = tags.get("correlation_id").toString();
        final long findingTimestamp = finding.getTimestamp().toEpochMilli();
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"root", (Object)true);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.fetchSource(true);
        searchSourceBuilder.size(1);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{".opensearch-sap-correlation-metadata"});
        searchRequest.source(searchSourceBuilder);
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                if (response.isTimedOut()) {
                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                }
                Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
                final long counter = Long.parseLong(hitSource.get("counter").toString());
                MultiSearchRequest mSearchRequest = new MultiSearchRequest();
                for (String correlatedFinding : correlatedFindings) {
                    BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"finding1", (Object)correlatedFinding)).must((QueryBuilder)QueryBuilders.matchQuery((String)"finding2", (Object)""));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                    searchSourceBuilder.query((QueryBuilder)queryBuilder);
                    searchSourceBuilder.fetchSource(true);
                    searchSourceBuilder.size(10000);
                    SearchRequest searchRequest = new SearchRequest();
                    searchRequest.indices(new String[]{".opensearch-sap-correlation-history*"});
                    searchRequest.source(searchSourceBuilder);
                    searchRequest.preference(Preference.PRIMARY_FIRST.type());
                    mSearchRequest.add(searchRequest);
                }
                VectorEmbeddingsEngine.this.client.multiSearch(mSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                    public void onResponse(MultiSearchResponse items) {
                        MultiSearchResponse.Item[] responses = items.getResponses();
                        BulkRequest bulkRequest = new BulkRequest();
                        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        long prevCounter = -1L;
                        long totalNeighbors = 0L;
                        for (MultiSearchResponse.Item response : responses) {
                            if (response.isFailure()) {
                                log.info(response.getFailureMessage());
                                continue;
                            }
                            long totalHits = response.getResponse().getHits().getTotalHits().value;
                            totalNeighbors += totalHits;
                            int idx = 0;
                            while ((long)idx < totalHits) {
                                SearchHit hit = response.getResponse().getHits().getHits()[idx];
                                Map hitSource = hit.getSourceAsMap();
                                long neighborCounter = Long.parseLong(hitSource.get("counter").toString());
                                String correlatedFinding = hitSource.get("finding1").toString();
                                try {
                                    IndexRequest indexRequest;
                                    float[] corrVector = new float[3];
                                    if (counter != prevCounter) {
                                        for (int i = 0; i < 2; ++i) {
                                            corrVector[i] = (float)counter - 50.0f;
                                        }
                                        corrVector[0] = counter;
                                        corrVector[2] = timestampFeature;
                                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                        builder.field("root", false);
                                        builder.field("counter", counter);
                                        builder.field("finding1", finding.getId());
                                        builder.field("finding2", "");
                                        builder.field("logType", correlationId);
                                        builder.field("timestamp", findingTimestamp);
                                        builder.field("corr_vector", (Object)corrVector);
                                        builder.field("recordType", "finding");
                                        builder.field("scoreTimestamp", 0L);
                                        builder.endObject();
                                        indexRequest = (IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout);
                                        bulkRequest.add(indexRequest);
                                    }
                                    corrVector = new float[3];
                                    for (int i = 0; i < 2; ++i) {
                                        corrVector[i] = (float)counter - 50.0f;
                                    }
                                    corrVector[0] = (2.0f * (float)counter - 50.0f) / 2.0f;
                                    corrVector[1] = (2.0f * (float)neighborCounter - 50.0f) / 2.0f;
                                    corrVector[2] = timestampFeature;
                                    XContentBuilder corrBuilder = XContentFactory.jsonBuilder().startObject();
                                    corrBuilder.field("root", false);
                                    corrBuilder.field("counter", (long)((2.0f * (float)counter - 50.0f) / 2.0f));
                                    corrBuilder.field("finding1", finding.getId());
                                    corrBuilder.field("finding2", correlatedFinding);
                                    corrBuilder.field("logType", String.format(Locale.ROOT, "%s-%s", detectorType, logType));
                                    corrBuilder.field("timestamp", findingTimestamp);
                                    corrBuilder.field("corr_vector", (Object)corrVector);
                                    corrBuilder.field("recordType", "finding-finding");
                                    corrBuilder.field("scoreTimestamp", 0L);
                                    corrBuilder.field("corrRules", (Iterable)correlationRules);
                                    corrBuilder.endObject();
                                    indexRequest = (IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(corrBuilder).timeout(VectorEmbeddingsEngine.this.indexTimeout);
                                    bulkRequest.add(indexRequest);
                                }
                                catch (IOException ex) {
                                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(ex);
                                }
                                prevCounter = counter;
                                ++idx;
                            }
                        }
                        if (totalNeighbors > 0L) {
                            VectorEmbeddingsEngine.this.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                                public void onResponse(BulkResponse response) {
                                    if (response.hasFailures()) {
                                        VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Correlation of finding failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                    }
                                    VectorEmbeddingsEngine.this.correlateFindingAction.onOperation();
                                }

                                public void onFailure(Exception e) {
                                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                                }
                            });
                        } else {
                            VectorEmbeddingsEngine.this.insertOrphanFindings(detectorType, finding, timestampFeature, logTypes);
                        }
                    }

                    public void onFailure(Exception e) {
                        VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
            }
        });
    }

    public void insertOrphanFindings(final String detectorType, final Finding finding, final float timestampFeature, final Map<String, CustomLogType> logTypes) {
        Map<String, Object> tags = logTypes.get(detectorType).getTags();
        final String correlationId = tags.get("correlation_id").toString();
        final long findingTimestamp = finding.getTimestamp().toEpochMilli();
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"root", (Object)true);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.fetchSource(true);
        searchSourceBuilder.size(1);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{".opensearch-sap-correlation-metadata"});
        searchRequest.source(searchSourceBuilder);
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                if (response.isTimedOut()) {
                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                }
                try {
                    Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
                    final String id = response.getHits().getHits()[0].getId();
                    final long counter = Long.parseLong(hitSource.get("counter").toString());
                    long timestamp = Long.parseLong(hitSource.get("timestamp").toString());
                    if (counter == 0L) {
                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                        builder.field("root", true);
                        builder.field("counter", 50L);
                        builder.field("finding1", "");
                        builder.field("finding2", "");
                        builder.field("logType", "");
                        builder.field("timestamp", findingTimestamp);
                        builder.field("scoreTimestamp", 0L);
                        builder.endObject();
                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-metadata").id(id).source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        VectorEmbeddingsEngine.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                            public void onResponse(IndexResponse response) {
                                if (response.status().equals((Object)RestStatus.OK)) {
                                    try {
                                        float[] corrVector = new float[3];
                                        corrVector[0] = 50.0f;
                                        corrVector[2] = timestampFeature;
                                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                        builder.field("root", false);
                                        builder.field("counter", 50L);
                                        builder.field("finding1", finding.getId());
                                        builder.field("finding2", "");
                                        builder.field("logType", correlationId);
                                        builder.field("timestamp", findingTimestamp);
                                        builder.field("corr_vector", (Object)corrVector);
                                        builder.field("recordType", "finding");
                                        builder.field("scoreTimestamp", 0L);
                                        builder.endObject();
                                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                        VectorEmbeddingsEngine.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                                            public void onResponse(IndexResponse response) {
                                                if (response.status().equals((Object)RestStatus.CREATED)) {
                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onOperation();
                                                } else {
                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                                }
                                            }

                                            public void onFailure(Exception e) {
                                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                                            }
                                        });
                                    }
                                    catch (IOException ex) {
                                        VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(ex);
                                    }
                                }
                            }

                            public void onFailure(Exception e) {
                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                            }
                        });
                    } else if (findingTimestamp - timestamp > VectorEmbeddingsEngine.this.corrTimeWindow) {
                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                        builder.field("root", true);
                        builder.field("counter", 50L);
                        builder.field("finding1", "");
                        builder.field("finding2", "");
                        builder.field("logType", "");
                        builder.field("timestamp", findingTimestamp);
                        builder.field("scoreTimestamp", 0L);
                        builder.endObject();
                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-metadata").id(id).source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        VectorEmbeddingsEngine.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                            public void onResponse(IndexResponse response) {
                                if (response.status().equals((Object)RestStatus.OK)) {
                                    VectorEmbeddingsEngine.this.correlateFindingAction.onOperation();
                                    try {
                                        float[] corrVector = new float[3];
                                        corrVector[0] = 50.0f;
                                        corrVector[2] = timestampFeature;
                                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                        builder.field("root", false);
                                        builder.field("counter", 50L);
                                        builder.field("finding1", finding.getId());
                                        builder.field("finding2", "");
                                        builder.field("logType", Integer.valueOf(((CustomLogType)logTypes.get(detectorType)).getTags().get("correlation_id").toString()).toString());
                                        builder.field("timestamp", findingTimestamp);
                                        builder.field("corr_vector", (Object)corrVector);
                                        builder.field("recordType", "finding");
                                        builder.field("scoreTimestamp", 0L);
                                        builder.endObject();
                                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                        VectorEmbeddingsEngine.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                                            public void onResponse(IndexResponse response) {
                                                if (response.status().equals((Object)RestStatus.CREATED)) {
                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onOperation();
                                                } else {
                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                                }
                                            }

                                            public void onFailure(Exception e) {
                                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                                            }
                                        });
                                    }
                                    catch (IOException ex) {
                                        VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(ex);
                                    }
                                }
                            }

                            public void onFailure(Exception e) {
                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                            }
                        });
                    } else {
                        float[] query = new float[3];
                        for (int i = 0; i < 2; ++i) {
                            query[i] = (2.0f * (float)counter - 50.0f) / 2.0f;
                        }
                        query[2] = timestampFeature;
                        CorrelationQueryBuilder correlationQueryBuilder = new CorrelationQueryBuilder("corr_vector", query, 100, (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding1", (Object)"")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding2", (Object)"")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - VectorEmbeddingsEngine.this.corrTimeWindow)).lte((Object)(findingTimestamp + VectorEmbeddingsEngine.this.corrTimeWindow))));
                        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                        searchSourceBuilder.query((QueryBuilder)correlationQueryBuilder);
                        searchSourceBuilder.fetchSource(true);
                        searchSourceBuilder.size(1);
                        SearchRequest searchRequest = new SearchRequest();
                        searchRequest.indices(new String[]{".opensearch-sap-correlation-history*"});
                        searchRequest.source(searchSourceBuilder);
                        searchRequest.preference(Preference.PRIMARY_FIRST.type());
                        VectorEmbeddingsEngine.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                            public void onResponse(SearchResponse response) {
                                long totalHits;
                                if (response.isTimedOut()) {
                                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                                }
                                SearchHit hit = (totalHits = response.getHits().getTotalHits().value) > 0L ? response.getHits().getHits()[0] : null;
                                long existCounter = 0L;
                                if (hit != null) {
                                    Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
                                    existCounter = Long.parseLong(hitSource.get("counter").toString());
                                }
                                if (totalHits == 0L || (float)existCounter != (float)((long)(2.0f * (float)counter - 50.0f)) / 2.0f) {
                                    try {
                                        float[] corrVector = new float[3];
                                        for (int i = 0; i < 2; ++i) {
                                            corrVector[i] = (float)counter - 50.0f;
                                        }
                                        corrVector[0] = counter;
                                        corrVector[2] = timestampFeature;
                                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                        builder.field("root", false);
                                        builder.field("counter", counter);
                                        builder.field("finding1", finding.getId());
                                        builder.field("finding2", "");
                                        builder.field("logType", Integer.valueOf(((CustomLogType)logTypes.get(detectorType)).getTags().get("correlation_id").toString()).toString());
                                        builder.field("timestamp", findingTimestamp);
                                        builder.field("corr_vector", (Object)corrVector);
                                        builder.field("recordType", "finding");
                                        builder.field("scoreTimestamp", 0L);
                                        builder.endObject();
                                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                        VectorEmbeddingsEngine.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                                            public void onResponse(IndexResponse response) {
                                                if (response.status().equals((Object)RestStatus.CREATED)) {
                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onOperation();
                                                } else {
                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                                }
                                            }

                                            public void onFailure(Exception e) {
                                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                                            }
                                        });
                                    }
                                    catch (IOException ex) {
                                        VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(ex);
                                    }
                                } else {
                                    try {
                                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                        builder.field("root", true);
                                        builder.field("counter", counter + 50L);
                                        builder.field("finding1", "");
                                        builder.field("finding2", "");
                                        builder.field("logType", "");
                                        builder.field("timestamp", findingTimestamp);
                                        builder.field("scoreTimestamp", 0L);
                                        builder.endObject();
                                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-metadata").id(id).source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                        VectorEmbeddingsEngine.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                                            public void onResponse(IndexResponse response) {
                                                if (response.status().equals((Object)RestStatus.OK)) {
                                                    try {
                                                        float[] corrVector = new float[3];
                                                        for (int i = 0; i < 2; ++i) {
                                                            corrVector[i] = counter;
                                                        }
                                                        corrVector[0] = (float)counter + 50.0f;
                                                        corrVector[2] = timestampFeature;
                                                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                                        builder.field("root", false);
                                                        builder.field("counter", counter + 50L);
                                                        builder.field("finding1", finding.getId());
                                                        builder.field("finding2", "");
                                                        builder.field("logType", Integer.valueOf(((CustomLogType)logTypes.get(detectorType)).getTags().get("correlation_id").toString()).toString());
                                                        builder.field("timestamp", findingTimestamp);
                                                        builder.field("corr_vector", (Object)corrVector);
                                                        builder.field("recordType", "finding");
                                                        builder.field("scoreTimestamp", 0L);
                                                        builder.endObject();
                                                        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(builder).timeout(VectorEmbeddingsEngine.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                                        VectorEmbeddingsEngine.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                                                            public void onResponse(IndexResponse response) {
                                                                if (response.status().equals((Object)RestStatus.CREATED)) {
                                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onOperation();
                                                                } else {
                                                                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                                                }
                                                            }

                                                            public void onFailure(Exception e) {
                                                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                                                            }
                                                        });
                                                    }
                                                    catch (IOException ex) {
                                                        VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(ex);
                                                    }
                                                }
                                            }

                                            public void onFailure(Exception e) {
                                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                                            }
                                        });
                                    }
                                    catch (IOException ex) {
                                        VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(ex);
                                    }
                                }
                            }

                            public void onFailure(Exception e) {
                                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
                            }
                        });
                    }
                }
                catch (IOException ex) {
                    VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(ex);
                }
            }

            public void onFailure(Exception e) {
                VectorEmbeddingsEngine.this.correlateFindingAction.onFailures(e);
            }
        });
    }
}

