/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.dsi;

import java.lang.ref.WeakReference;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.dsi.AbstractActiveSpeakerDetector;
import org.jitsi.utils.dsi.SpeakerRanking;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DominantSpeakerIdentification<T>
extends AbstractActiveSpeakerDetector<T> {
    private static final double C1 = 3.0;
    private static final double C2 = 2.0;
    private static final double C3 = 0.0;
    private static final boolean DEBUG;
    private static final long DECISION_INTERVAL = 300L;
    private static final long DECISION_MAKER_IDLE_TIMEOUT = 15000L;
    private static final long LEVEL_IDLE_TIMEOUT = 40L;
    private static final Logger logger;
    private static final int LONG_COUNT = 1;
    private static final int LONG_THRESHOLD = 4;
    private static final int MAX_LEVEL = 127;
    private static final int MIN_LEVEL = 0;
    private static final int MIN_LEVEL_WINDOW_LENGTH = 750;
    private static final double MIN_SPEECH_ACTIVITY_SCORE = 1.0E-10;
    private static final int MEDIUM_THRESHOLD = 7;
    private static final int N1 = 13;
    private static final int N1_SUBUNIT_LENGTH = 10;
    private static final int N2 = 5;
    private static final int N3 = 10;
    private static final long SPEAKER_IDLE_TIMEOUT = 3600000L;
    private static final ScheduledExecutorService DEFAULT_EXECUTOR;
    private DecisionMaker decisionMaker;
    private T dominantId;
    private long lastDecisionTime;
    private long lastLevelChangedTime;
    private long lastLevelIdleTime;
    private final double[] relativeSpeechActivities = new double[3];
    private final Map<T, Speaker<T>> speakers = new HashMap<T, Speaker<T>>();
    private final boolean enableSilence;
    private final long timeoutToSilenceInterval;
    private final ArrayList<Speaker<T>> loudest = new ArrayList();
    private final Clock clock;
    private final ScheduledExecutorService executor;
    private int numLoudestToTrack = 0;
    private int energyExpireTimeMs = 150;
    private int energyAlphaPct = 50;

    private static long binomialCoefficient(int n, int r) {
        int m4 = n - r;
        if (r < m4) {
            r = m4;
        }
        long t2 = 1L;
        int i = n;
        int j = 1;
        while (i > r) {
            t2 = t2 * (long)i / (long)j;
            --i;
            ++j;
        }
        return t2;
    }

    private static boolean computeBigs(byte[] littles, byte[] bigs, int threshold) {
        int bigLength = bigs.length;
        int littleLengthPerBig = littles.length / bigLength;
        boolean changed = false;
        int l = 0;
        for (int b = 0; b < bigLength; ++b) {
            byte sum = 0;
            int lEnd = l + littleLengthPerBig;
            while (l < lEnd) {
                if (littles[l] > threshold) {
                    sum = (byte)(sum + 1);
                }
                ++l;
            }
            if (bigs[b] == sum) continue;
            bigs[b] = sum;
            changed = true;
        }
        return changed;
    }

    private static double computeSpeechActivityScore(int vL, int nR, double lambda) {
        double p = 0.5;
        double speechActivityScore = Math.log(DominantSpeakerIdentification.binomialCoefficient(nR, vL)) + (double)vL * Math.log(p) + (double)(nR - vL) * Math.log(1.0 - p) - Math.log(lambda) + lambda * (double)vL;
        if (speechActivityScore < 1.0E-10) {
            speechActivityScore = 1.0E-10;
        }
        return speechActivityScore;
    }

    public DominantSpeakerIdentification() {
        this(Clock.systemUTC(), DEFAULT_EXECUTOR);
    }

    public DominantSpeakerIdentification(long silenceTimeout) {
        this(Clock.systemUTC(), DEFAULT_EXECUTOR, silenceTimeout);
    }

    public DominantSpeakerIdentification(Clock clock, ScheduledExecutorService executor) {
        this(clock, executor, -1L);
    }

    public DominantSpeakerIdentification(Clock clock, ScheduledExecutorService executor, long silenceTimeout) {
        this.clock = clock;
        this.executor = executor;
        this.timeoutToSilenceInterval = silenceTimeout;
        this.enableSilence = silenceTimeout > 0L;
    }

    public synchronized void setLoudestConfig(int numLoudestToTrack_, int energyExpireTimeMs_, int energyAlphaPct_) {
        this.numLoudestToTrack = numLoudestToTrack_;
        this.energyExpireTimeMs = energyExpireTimeMs_;
        this.energyAlphaPct = energyAlphaPct_;
        logger.trace(() -> "numLoudestToTrack = " + this.numLoudestToTrack);
        logger.trace(() -> "energyExpireTimeMs = " + this.energyExpireTimeMs);
        logger.trace(() -> "energyAlphaPct = " + this.energyAlphaPct);
        while (this.loudest.size() > this.numLoudestToTrack) {
            this.loudest.remove(this.numLoudestToTrack);
        }
    }

    synchronized void decisionMakerExited(DecisionMaker decisionMaker) {
        if (this.decisionMaker == decisionMaker) {
            this.decisionMaker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject doGetJSON() {
        JSONObject jsonObject;
        if (DEBUG) {
            DominantSpeakerIdentification dominantSpeakerIdentification = this;
            synchronized (dominantSpeakerIdentification) {
                jsonObject = new JSONObject();
                T dominantSpeaker = this.getDominantSpeaker();
                jsonObject.put("dominantSpeaker", Objects.toString(dominantSpeaker));
                Collection<Speaker<T>> speakersCollection = this.speakers.values();
                JSONArray speakersArray = new JSONArray();
                for (Speaker<T> speaker : speakersCollection) {
                    JSONObject speakerJSONObject = new JSONObject();
                    speakerJSONObject.put("id", speaker.id.toString());
                    speakerJSONObject.put("levels", speaker.getLevels());
                    speakersArray.add(speakerJSONObject);
                }
                jsonObject.put("speakers", speakersArray);
            }
        } else {
            jsonObject = null;
        }
        return jsonObject;
    }

    public T getDominantSpeaker() {
        return this.dominantId;
    }

    @NotNull
    private synchronized Speaker<T> getOrCreateSpeaker(T id) {
        Speaker<T> speaker = this.speakers.get(id);
        if (speaker == null) {
            speaker = new Speaker<T>(id);
            this.speakers.put(id, speaker);
            this.maybeStartDecisionMaker();
        }
        return speaker;
    }

    private synchronized SpeakerRanking updateLoudestList(Speaker<T> speaker, int level, long now) {
        Speaker<T> cur;
        int rank;
        boolean isDominant;
        boolean bl = isDominant = this.dominantId != null && this.dominantId.equals(speaker.id);
        if (level < 0) {
            int rank2;
            for (rank2 = 0; rank2 < this.loudest.size() && this.loudest.get(rank2) != speaker; ++rank2) {
            }
            return new SpeakerRanking(isDominant, rank2, speaker.energyScore);
        }
        speaker.energyScore = (this.energyAlphaPct * level + (100 - this.energyAlphaPct) * speaker.energyScore + 50) / 100;
        if (this.numLoudestToTrack == 0) {
            return new SpeakerRanking(isDominant, 0, speaker.energyScore);
        }
        long oldestValid = now - (long)this.energyExpireTimeMs;
        logger.trace(() -> "Want to add " + speaker.id.toString() + " with score " + speaker.energyScore + ". Last level = " + level + ".");
        int i = 0;
        while (i < this.loudest.size()) {
            Speaker<T> cur2 = this.loudest.get(i);
            if (cur2.getLastLevelChangedTime() < oldestValid) {
                logger.trace(() -> "Removing " + cur.id.toString() + ". old.");
                this.loudest.remove(i);
                continue;
            }
            if (cur2 == speaker) {
                logger.trace(() -> "Removing " + cur.id.toString() + ". same.");
                this.loudest.remove(i);
                continue;
            }
            ++i;
        }
        for (rank = 0; rank < this.loudest.size(); ++rank) {
            cur = this.loudest.get(rank);
            if (cur.energyScore < speaker.energyScore) break;
        }
        if (rank < this.numLoudestToTrack) {
            int pos = rank;
            logger.trace(() -> "Adding " + speaker.id.toString() + " at position " + pos + ".");
            this.loudest.add(rank, speaker);
            if (this.loudest.size() > this.numLoudestToTrack) {
                this.loudest.remove(this.numLoudestToTrack);
            }
        }
        if (logger.isTraceEnabled()) {
            for (i = 0; i < this.loudest.size(); ++i) {
                cur = this.loudest.get(i);
                logger.trace("New list: " + i + ": " + cur.id.toString() + ": " + cur.energyScore + ".");
            }
        }
        return new SpeakerRanking(isDominant, rank, speaker.energyScore);
    }

    public synchronized boolean isAmongLoudest(T id) {
        return this.loudest.stream().anyMatch(speaker -> speaker.id.equals(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpeakerRanking levelChanged(T id, int level) {
        Speaker<T> speaker;
        long now = this.clock.millis();
        DominantSpeakerIdentification dominantSpeakerIdentification = this;
        synchronized (dominantSpeakerIdentification) {
            speaker = this.getOrCreateSpeaker(id);
            if (this.lastLevelChangedTime < now) {
                this.lastLevelChangedTime = now;
                this.maybeStartDecisionMaker();
            }
        }
        int cookedLevel = speaker.levelChanged(level, now);
        return this.updateLoudestList(speaker, cookedLevel, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDecision(long now) {
        Object oldDominantSpeakerValue = null;
        Object newDominantSpeakerValue = null;
        DominantSpeakerIdentification dominantSpeakerIdentification = this;
        synchronized (dominantSpeakerIdentification) {
            Object newDominantId;
            int speakerCount = this.speakers.size();
            if (speakerCount == 0) {
                newDominantId = null;
            } else if (speakerCount == 1) {
                Speaker<T> speaker = this.speakers.values().iterator().next();
                newDominantId = speaker.id;
                if (this.enableSilence) {
                    speaker.evaluateSpeechActivityScores(now);
                    long timeSinceNonSilence = now - speaker.lastNonSilence;
                    if (timeSinceNonSilence > this.timeoutToSilenceInterval) {
                        newDominantId = null;
                    }
                }
            } else {
                long timeSinceNonSilence;
                Speaker<T> dominantSpeaker;
                boolean inSilence = this.enableSilence && this.dominantId == null;
                Speaker<T> speaker = dominantSpeaker = this.dominantId == null ? null : this.speakers.get(this.dominantId);
                if (dominantSpeaker == null) {
                    Map.Entry<T, Speaker<T>> s2 = this.speakers.entrySet().iterator().next();
                    dominantSpeaker = s2.getValue();
                    newDominantId = s2.getKey();
                } else {
                    newDominantId = dominantSpeaker.id;
                }
                if (dominantSpeaker != null) {
                    dominantSpeaker.evaluateSpeechActivityScores(now);
                }
                double[] relativeSpeechActivities = this.relativeSpeechActivities;
                double newDominantC2 = 2.0;
                for (Map.Entry<T, Speaker<T>> s3 : this.speakers.entrySet()) {
                    Speaker<T> speaker2 = s3.getValue();
                    if (speaker2 == dominantSpeaker) continue;
                    speaker2.evaluateSpeechActivityScores(now);
                    for (int interval2 = 0; interval2 < relativeSpeechActivities.length; ++interval2) {
                        double dominantSpeakerScore = dominantSpeaker == null ? 1.0E-10 : dominantSpeaker.getSpeechActivityScore(interval2);
                        relativeSpeechActivities[interval2] = Math.log(speaker2.getSpeechActivityScore(interval2) / dominantSpeakerScore);
                    }
                    double c1 = relativeSpeechActivities[0];
                    double c2 = relativeSpeechActivities[1];
                    double c3 = relativeSpeechActivities[2];
                    if (!(c1 > 3.0) || !(c2 > 2.0) || !(c3 > 0.0) || !(c2 > newDominantC2)) continue;
                    newDominantC2 = c2;
                    newDominantId = s3.getKey();
                }
                if (this.enableSilence && dominantSpeaker != null && newDominantId == dominantSpeaker.id && (timeSinceNonSilence = now - dominantSpeaker.lastNonSilence) > this.timeoutToSilenceInterval) {
                    newDominantId = null;
                }
            }
            if ((newDominantId != null || this.enableSilence) && !Objects.equals(newDominantId, this.dominantId)) {
                oldDominantSpeakerValue = this.dominantId;
                this.dominantId = newDominantId;
                newDominantSpeakerValue = this.dominantId;
            }
        }
        if ((newDominantSpeakerValue != null || this.enableSilence) && !Objects.equals(newDominantSpeakerValue, oldDominantSpeakerValue)) {
            this.fireActiveSpeakerChanged(newDominantSpeakerValue);
        }
    }

    private synchronized void maybeStartDecisionMaker() {
        if (this.decisionMaker == null && !this.speakers.isEmpty()) {
            DecisionMaker decisionMaker = new DecisionMaker(this);
            boolean scheduled = false;
            this.decisionMaker = decisionMaker;
            try {
                this.executor.execute(decisionMaker);
                scheduled = true;
            }
            finally {
                if (!scheduled && this.decisionMaker == decisionMaker) {
                    this.decisionMaker = null;
                }
            }
        }
    }

    private long runInDecisionMaker() {
        long now = this.clock.millis();
        long levelIdleTimeout = 40L - (now - this.lastLevelIdleTime);
        long sleep = 0L;
        if (levelIdleTimeout <= 0L) {
            if (this.lastLevelIdleTime != 0L) {
                this.timeoutIdleLevels(now);
            }
            this.lastLevelIdleTime = now;
        } else {
            sleep = levelIdleTimeout;
        }
        long decisionTimeout = 300L - (now - this.lastDecisionTime);
        if (decisionTimeout <= 0L) {
            this.lastDecisionTime = now;
            this.makeDecision(now);
            decisionTimeout = 300L - (this.clock.millis() - now);
        }
        if (decisionTimeout > 0L && sleep > decisionTimeout) {
            sleep = decisionTimeout;
        }
        return sleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long runInDecisionMaker(DecisionMaker decisionMaker) {
        DominantSpeakerIdentification dominantSpeakerIdentification = this;
        synchronized (dominantSpeakerIdentification) {
            long idle;
            if (this.decisionMaker != decisionMaker) {
                return -1L;
            }
            if (0L < this.lastDecisionTime && (idle = this.lastDecisionTime - this.lastLevelChangedTime) >= 15000L) {
                return -1L;
            }
        }
        return this.runInDecisionMaker();
    }

    private synchronized void timeoutIdleLevels(long now) {
        Iterator<Map.Entry<T, Speaker<T>>> i = this.speakers.entrySet().iterator();
        while (i.hasNext()) {
            Speaker<T> speaker = i.next().getValue();
            long idle = now - speaker.getLastLevelChangedTime();
            if (3600000L < idle && (this.dominantId == null || speaker.id != this.dominantId)) {
                i.remove();
                continue;
            }
            if (40L >= idle) continue;
            speaker.levelTimedOut();
        }
    }

    static {
        logger = new LoggerImpl(DominantSpeakerIdentification.class.getName());
        DEFAULT_EXECUTOR = Executors.newScheduledThreadPool(1, new CustomizableThreadFactory("dsi", true));
        DEBUG = logger.isDebugEnabled();
    }

    private class Speaker<U> {
        private final byte[] immediates = new byte[50];
        private long lastNonSilence = -1L;
        private double immediateSpeechActivityScore = 1.0E-10;
        private long lastLevelChangedTime;
        private final byte[] levels;
        private final byte[] longs;
        private double longSpeechActivityScore;
        private final byte[] mediums;
        private double mediumSpeechActivityScore;
        private byte minLevel;
        private byte nextMinLevel;
        private int nextMinLevelWindowLength;
        int energyScore;
        public final U id;

        public Speaker(U id) {
            this.lastLevelChangedTime = DominantSpeakerIdentification.this.clock.millis();
            this.longs = new byte[1];
            this.longSpeechActivityScore = 1.0E-10;
            this.mediums = new byte[10];
            this.mediumSpeechActivityScore = 1.0E-10;
            this.minLevel = 0;
            this.nextMinLevel = 0;
            this.id = id;
            this.levels = new byte[this.immediates.length];
        }

        private boolean computeImmediates() {
            byte[] immediates = this.immediates;
            byte[] levels = this.levels;
            byte minLevel = (byte)(this.minLevel + 10);
            boolean changed = false;
            for (int i = 0; i < immediates.length; ++i) {
                byte immediate;
                byte level = levels[i];
                if (level < minLevel) {
                    level = 0;
                }
                if (immediates[i] == (immediate = (byte)(level / 10))) continue;
                immediates[i] = immediate;
                changed = true;
            }
            return changed;
        }

        private boolean computeLongs() {
            return DominantSpeakerIdentification.computeBigs(this.mediums, this.longs, 4);
        }

        private boolean computeMediums() {
            return DominantSpeakerIdentification.computeBigs(this.immediates, this.mediums, 7);
        }

        private void evaluateImmediateSpeechActivityScore() {
            this.immediateSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.immediates[0], 13, 0.78);
        }

        private void evaluateLongSpeechActivityScore(long now) {
            this.longSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.longs[0], 10, 47.0);
            if (this.longSpeechActivityScore > 1.0E-10) {
                this.lastNonSilence = now;
            }
        }

        private void evaluateMediumSpeechActivityScore() {
            this.mediumSpeechActivityScore = DominantSpeakerIdentification.computeSpeechActivityScore(this.mediums[0], 5, 24.0);
        }

        synchronized void evaluateSpeechActivityScores(long now) {
            if (this.computeImmediates()) {
                this.evaluateImmediateSpeechActivityScore();
                if (this.computeMediums()) {
                    this.evaluateMediumSpeechActivityScore();
                    if (this.computeLongs()) {
                        this.evaluateLongSpeechActivityScore(now);
                    }
                }
            }
        }

        public synchronized long getLastLevelChangedTime() {
            return this.lastLevelChangedTime;
        }

        String getLevels() {
            byte[] src = this.levels;
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int s2 = src.length - 1; s2 >= 0; --s2) {
                sb.append(src[s2]);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        double getSpeechActivityScore(int interval2) {
            switch (interval2) {
                case 0: {
                    return this.immediateSpeechActivityScore;
                }
                case 1: {
                    return this.mediumSpeechActivityScore;
                }
                case 2: {
                    return this.longSpeechActivityScore;
                }
            }
            throw new IllegalArgumentException("interval " + interval2);
        }

        public synchronized int levelChanged(int level, long time) {
            if (this.lastLevelChangedTime <= time) {
                this.lastLevelChangedTime = time;
                int b = level < 0 ? 0 : (level > 127 ? 127 : (int)((byte)level));
                System.arraycopy(this.levels, 0, this.levels, 1, this.levels.length - 1);
                this.levels[0] = b;
                this.updateMinLevel((byte)b);
                return b >= this.minLevel + 10 ? b : 0;
            }
            return -1;
        }

        public synchronized void levelTimedOut() {
            this.levelChanged(0, this.lastLevelChangedTime);
        }

        private void updateMinLevel(byte level) {
            if (level != 0) {
                if (this.minLevel == 0 || this.minLevel > level) {
                    this.minLevel = level;
                    this.nextMinLevel = 0;
                    this.nextMinLevelWindowLength = 0;
                } else if (this.nextMinLevel == 0) {
                    this.nextMinLevel = level;
                    this.nextMinLevelWindowLength = 1;
                } else {
                    if (this.nextMinLevel > level) {
                        this.nextMinLevel = level;
                    }
                    ++this.nextMinLevelWindowLength;
                    if (this.nextMinLevelWindowLength >= 750) {
                        double newMinLevel = Math.sqrt((double)this.minLevel * (double)this.nextMinLevel);
                        if (newMinLevel < 0.0) {
                            newMinLevel = 0.0;
                        } else if (newMinLevel > 127.0) {
                            newMinLevel = 127.0;
                        }
                        this.minLevel = (byte)newMinLevel;
                        this.nextMinLevel = 0;
                        this.nextMinLevelWindowLength = 0;
                    }
                }
            }
        }
    }

    private static class DecisionMaker
    implements Runnable {
        private final WeakReference<DominantSpeakerIdentification<?>> algorithm;

        public DecisionMaker(DominantSpeakerIdentification<?> algorithm) {
            this.algorithm = new WeakReference(algorithm);
        }

        @Override
        public void run() {
            boolean exit = false;
            DominantSpeakerIdentification algorithm = (DominantSpeakerIdentification)this.algorithm.get();
            if (algorithm == null) {
                exit = true;
            } else {
                long sleep;
                try {
                    sleep = algorithm.runInDecisionMaker(this);
                }
                catch (Exception e) {
                    sleep = -1L;
                }
                if (sleep < 0L) {
                    exit = true;
                } else {
                    algorithm.executor.schedule(this, sleep, TimeUnit.MILLISECONDS);
                }
            }
            if (exit && (algorithm = (DominantSpeakerIdentification)this.algorithm.get()) != null) {
                algorithm.decisionMakerExited(this);
            }
        }
    }
}

