/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.audio;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.openstreetmap.josm.io.audio.AudioException;
import org.openstreetmap.josm.io.audio.AudioListener;
import org.openstreetmap.josm.io.audio.JavaSoundPlayer;
import org.openstreetmap.josm.io.audio.SoundPlayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public final class AudioPlayer
extends Thread
implements AudioListener {
    private static volatile AudioPlayer audioPlayer;
    private State state = State.INITIALIZING;
    private static volatile Class<? extends SoundPlayer> soundPlayerClass;
    private SoundPlayer soundPlayer;
    private URL playingUrl = null;
    private final Execute command = new Execute();

    public static void play(URL url) throws InterruptedException, IOException {
        AudioPlayer instance = AudioPlayer.getInstance();
        if (instance != null) {
            instance.command.play(url, 0.0, 1.0);
        }
    }

    public static void play(URL url, double seconds) throws InterruptedException, IOException {
        AudioPlayer instance = AudioPlayer.getInstance();
        if (instance != null) {
            instance.command.play(url, seconds, 1.0);
        }
    }

    public static void play(URL url, double seconds, double speed) throws InterruptedException, IOException {
        AudioPlayer instance = AudioPlayer.getInstance();
        if (instance != null) {
            instance.command.play(url, seconds, speed);
        }
    }

    public static void pause() throws InterruptedException, IOException {
        AudioPlayer instance = AudioPlayer.getInstance();
        if (instance != null) {
            instance.command.pause();
        }
    }

    public static URL url() {
        AudioPlayer instance = AudioPlayer.getInstance();
        return instance == null ? null : instance.playingUrl;
    }

    public static boolean paused() {
        AudioPlayer instance = AudioPlayer.getInstance();
        return instance != null && instance.state == State.PAUSED;
    }

    public static boolean playing() {
        AudioPlayer instance = AudioPlayer.getInstance();
        return instance != null && instance.state == State.PLAYING;
    }

    public static double position() {
        AudioPlayer instance = AudioPlayer.getInstance();
        return instance == null ? -1.0 : instance.soundPlayer.position();
    }

    public static double speed() {
        AudioPlayer instance = AudioPlayer.getInstance();
        return instance == null ? -1.0 : instance.soundPlayer.speed();
    }

    private static AudioPlayer getInstance() {
        if (audioPlayer != null) {
            return audioPlayer;
        }
        try {
            audioPlayer = new AudioPlayer();
            return audioPlayer;
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException ex) {
            Logging.error(ex);
            return null;
        }
    }

    public static void reset() {
        if (audioPlayer != null) {
            try {
                AudioPlayer.pause();
            }
            catch (IOException | InterruptedException e) {
                Logging.warn(e);
            }
            AudioPlayer.audioPlayer.playingUrl = null;
        }
    }

    private AudioPlayer() {
        double leadIn = Config.getPref().getDouble("audio.leadin", 1.0);
        double calibration = Config.getPref().getDouble("audio.calibration", 1.0);
        try {
            if (soundPlayerClass == null) {
                soundPlayerClass = Class.forName("org.openstreetmap.josm.io.audio.fx.JavaFxMediaPlayer");
            }
            this.soundPlayer = soundPlayerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            Logging.debug(e);
            Logging.warn("JOSM compiled without Java FX support. Falling back to Java Sound API");
        }
        catch (NoClassDefFoundError | JosmRuntimeException e) {
            Logging.debug(e);
            Logging.warn("Java FX is unavailable. Falling back to Java Sound API");
        }
        if (this.soundPlayer == null) {
            this.soundPlayer = new JavaSoundPlayer(leadIn, calibration);
        }
        this.soundPlayer.addAudioListener(this);
        this.start();
        while (this.state == State.INITIALIZING) {
            AudioPlayer.yield();
        }
    }

    @Override
    public void run() {
        this.playingUrl = null;
        while (true) {
            try {
                while (true) {
                    switch (this.state) {
                        case INITIALIZING: {
                            this.state = State.NOTPLAYING;
                            break;
                        }
                        case NOTPLAYING: 
                        case PAUSED: {
                            AudioPlayer.sleep(200L);
                            break;
                        }
                        case PLAYING: {
                            this.command.possiblyInterrupt();
                            if (this.soundPlayer.playing(this.command)) {
                                this.playingUrl = null;
                                this.state = State.NOTPLAYING;
                            }
                            this.command.possiblyInterrupt();
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                AudioPlayer.interrupted();
                State stateChange = this.state;
                this.state = State.INTERRUPTED;
                try {
                    switch (this.command.command()) {
                        case PLAY: {
                            this.soundPlayer.play(this.command, stateChange, this.playingUrl);
                            stateChange = State.PLAYING;
                            break;
                        }
                        case PAUSE: {
                            this.soundPlayer.pause(this.command, stateChange, this.playingUrl);
                            stateChange = State.PAUSED;
                            break;
                        }
                    }
                    this.command.ok(stateChange);
                }
                catch (IOException | IllegalArgumentException | SecurityException | AudioException startPlayingException) {
                    Logging.error(startPlayingException);
                    this.command.failed(startPlayingException);
                }
                continue;
            }
            catch (IOException | AudioException e) {
                this.state = State.NOTPLAYING;
                Logging.error(e);
                continue;
            }
            break;
        }
    }

    @Override
    public void playing(URL playingUrl) {
        this.playingUrl = playingUrl;
    }

    public static Class<? extends SoundPlayer> getSoundPlayerClass() {
        return soundPlayerClass;
    }

    public static void setSoundPlayerClass(Class<? extends SoundPlayer> playerClass) {
        if (audioPlayer != null) {
            throw new IllegalStateException("Audio player already initialized");
        }
        soundPlayerClass = Objects.requireNonNull(playerClass);
    }

    public class Execute {
        private Command command;
        private Result result;
        private Exception exception;
        private URL url;
        private double offset;
        private double speed;

        protected void play(URL url, double offset, double speed) throws InterruptedException, IOException {
            this.url = url;
            this.offset = offset;
            this.speed = speed;
            this.command = Command.PLAY;
            this.result = Result.WAITING;
            this.send();
        }

        protected void pause() throws InterruptedException, IOException {
            this.command = Command.PAUSE;
            this.send();
        }

        private void send() throws InterruptedException, IOException {
            this.result = Result.WAITING;
            AudioPlayer.this.interrupt();
            while (this.result == Result.WAITING) {
                Thread.sleep(10L);
            }
            if (this.result == Result.FAILED) {
                throw new IOException(this.exception);
            }
        }

        protected void possiblyInterrupt() throws InterruptedException {
            if (Thread.interrupted() || this.result == Result.WAITING) {
                throw new InterruptedException();
            }
        }

        protected void failed(Exception e) {
            this.exception = e;
            this.result = Result.FAILED;
            AudioPlayer.this.state = State.NOTPLAYING;
        }

        protected void ok(State newState) {
            this.result = Result.OK;
            AudioPlayer.this.state = newState;
        }

        public double offset() {
            return this.offset;
        }

        public double speed() {
            return this.speed;
        }

        public URL url() {
            return this.url;
        }

        public Command command() {
            return this.command;
        }
    }

    public static enum Result {
        WAITING,
        OK,
        FAILED;

    }

    public static enum Command {
        PLAY,
        PAUSE;

    }

    public static enum State {
        INITIALIZING,
        NOTPLAYING,
        PLAYING,
        PAUSED,
        INTERRUPTED;

    }
}

